package cn.smarthse.modules.health.entity.work.reform.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * 各企业风险完成情况
 *
 * @author DELL
 * @date 2023/07/26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Table(name = "company_risk_completion")
public class CompanyRiskCompletion implements Serializable {
    private static final long serialVersionUID = 1L;


    /**
     * 企业id
     */
    @Id
    private Long id;

    /**
     * fullname企业名称
     */
    private String name;

    /**
     * 企业的区域id
     */
    @Transient
    private Long companyAreaId;

    /**
     * 企业区域名称
     */
    @Transient
    private String companyAreaName;

    /**
     * 省编号
     */
    private Long provinceId;
    @Transient
    private String provinceName;

    /**
     * 市编号
     */
    private Long cityId;
    @Transient
    private String cityName;


    /**
     * 区域ID
     */
    private Long areaId;
    @Transient
    private String areaName;


    /**
     * 乡镇街道编号
     */
    private Long streetId;
    @Transient
    private String streetName;


    /**
     * 是否已推送风险 1已推送，0未推送
     */
    private Integer pickupCount;

    /**
     * 1:24年下半年推送的   0:24年下半年未推送
     */
    private Integer belongType;

    /**
     * 申报是否已完成：1是0否
     */
    @Column(name = "`declare`")
    private Boolean declare;
    private Integer declareNum;
    private Integer declareCount;//申报数据数量

    /**
     * 体检是否已完成：1是0否
     */
    private Boolean physicalExamination;
    private Integer physicalExaminationNum;

    /**
     * 检测是否已完成：1是0否
     */
    @Column(name = "`check`")
    private Boolean check;
    private Integer checkNum;

    /**
     * 培训是否已完成：1是0否
     */
    private Boolean training;
    private Integer trainingNum;

    /**
     * 培训主要负责人证书12 是否完整：1是0否
     */
    private Boolean trainingZ;

    /**
     * 培训管理人员证书13 是否完整：1是0否
     */
    private Boolean trainingM;

    /**
     * 三同时是否已完成：1是0否
     */
    private Boolean threeSimultaneous;
    private Integer threeSimultaneousNum;
    private Integer threeAllComplete;//全部三同时数量
    private Integer threeComplete;//未完成三同时数量

    /**
     * 个人防护用品是否已完成：1是0否
     */
    private Boolean protectEquip;
    private Integer protectEquipNum;

    /**
     * 现场示警标识是否已完成：1是0否
     */
    private Boolean warnSignManage;
    private Integer warnSignManageNum;

    /**
     * 职业卫生档案是否已完成：1是0否
     */
    private Boolean healthManageFiles;
    private Integer healthManageFilesNum;
    private Integer healthComplete;//已完成档案数量

    /**
     * 不完整画像数量(8大项)
     */
    private Integer noCompletedNum;

    /**
     * 不完整画像数量(10大项)
     */
    private Integer noCompletedNum10;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最新验收时间
     */
    private Date acceptanceDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;


    private Boolean jccb;//检测超标是否已完成
    private Boolean jjz;
    private Boolean yszyb;
    private Boolean jccbzg;

    private Integer jccbNum;//检测超标风险数量
    private Integer jjzNum;
    private Integer yszybNum;
    private Integer jccbzgNum;

    private Integer jccbNoNum;//检测超标未化解风险数量
    private Integer jjzNoNum;
    private Integer yszybNoNum;
    private Integer jccbzgNoNum;

    private Integer physicalCurCount;//当年体检数据数量（到10.31号）
    private Integer checkCurCount;//当年检测数据数量（到10.31号）


    /**
     * 企业主要负责人
     */
    @Transient
    private String mainLeaderName;
    /**
     * 负责人手机号码
     */
    @Transient
    private String mainLeaderTel;
    /**
     * 职业卫生管理人员
     */

    @Transient
    private String occManagerName;
    /**
     * ְ管理人员手机号码
     */
    @Transient
    private String occManagerTel;

    @Transient
    private Byte searchAreaLevel;//搜索区域等级

    @Transient
    private Long searchAreaId;//搜索区域id

    @Transient
    private String keyWord;

    @Transient
    private Boolean Completed;//完整情况：1已完整 0未完整  Completed和type组合一起才能使用
    /**
     *  '申报'  0, '体检'  1, '检测'  2 , '培训'  3 , '三同时' 4, '个人防护' 5 , '警示标识' 6 , '职业卫生档案' 7, '检测结果超标' 8, '职业禁忌证者处置' 9,'疑似职业病处置'10,'监测结果超标' 11
     */
    @Transient //完成数量
    private Integer completedNum;

    @Transient
    private String type;

    @Transient  //1-三同时 2-个人防护用品 3-警示标识 4-培训 5-档案 6-申报 7-体检
    private Byte generationSource;

    @Transient
    private Boolean onlyThisLevel;

    @Transient
    private List cids;

    @Transient
    private Integer archive2;
    @Transient
    private Integer archive3;
    @Transient
    private Integer archive4;

    @Transient
    private Boolean isExistRadioactivity;//是否放射单位

    @Transient
    private Boolean isShowOnlyCheckFileRiskCompleted = false;//是否仅佐证材料化解检测风险企业
    @Transient
    private Boolean isShowOnlyPhyFileRiskCompleted = false;//是否仅佐证材料化解体检风险企业

    @Transient
    private Boolean isExportMaxAccTime = false;//是否导出最新化解时间

    @Transient
    private Boolean jhrs= false;//是否包含接害人数小于3的数据

    @Transient
    private Boolean containPausedBusiness = false;//是否包含暂停企业

    @Transient
    private Integer isPatrol;//是否已经巡查企业 null 0未巡查 1已巡查

    @Transient
    private List<Long> patrolList;

    @Transient
    private Map<String,String> params;

    @Transient
    private Integer year;

    /**
     * 系统部署来源SystemDeploymentSourceEnum
     */
    @Transient
    private Byte systemDeploymentSource;

    @Transient
    private String description;//风险显示描述

    @Transient
    Integer searchType; // 2 监测风险清单

    /**
     * 是否新建企业引导阶段
     */
    @Transient
    private Boolean isGuideNewCompany=false;
    /**
     * 是否粉尘一体化企业（1是 0否）
     */
    @Transient
    private Integer isFcImportanceCompany;
    /**
     * 是否分类对象 all,olddec,current,false,allCom所有企业
     */
    @Transient
    private String isClassified;
    @Transient
    private Boolean isShowHalfYear;//是否仅查看下半年推送风险的企业

    public String getDescriptionStr() {
        return description;
    }
}
