package cn.smarthse.modules.health.entity.work.reform.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 仅上传佐证材料化解风险企业清单
 *
 * @author DELL
 * @date 2023/07/26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CompanyCheckRiskCompletion implements Serializable {
    private static final long serialVersionUID = 1L;


    /**
     * 省编号
     */
    private Long provinceId;
    private String provinceName;

    /**
     * 市编号
     */
    private Long cityId;
    private String cityName;

    /**
     * 区域ID
     */
    private Long areaId;
    private String areaName;

    /**
     * 乡镇街道编号
     */
    private Long streetId;
    private String streetName;

    /**
     * 画像数量
     */
    private Integer keyFactoryNum;

    /**
     * 检测以化解风险数
     */
    private Integer checkRiskCompletedNum;

    /**
     * 仅佐证材料化解检测风险企业数量
     */
    private Integer noCheckRiskCompletedNum;

    /**
     * 仅佐证材料化解检测风险企业占比
     */
    private String noCheckRiskCompletedRate;

    /**
     * 占比是否大于15% （1大于，0小于）
     */
    private Integer percentage=0;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 创建时间
     */
    private Date updateDate;

    /**
     * 序列id
     */
    private int idx;

    /**
     * 当前顶部行政区划名称
     */
    private String currentHeadAreaName;
    private Long currentHeadAreaId;


    /**
     * 当前列表行政区划名称
     */
    private String currentListAreaName;
    private Long currentListAreaId;

    /**
     * 是否本级区域
     */
    private Boolean onlyThisLevelArea=false;
    /**
     * 本级区域id
     */
    private Long onlyThisLevelAreaId;
}
