package cn.smarthse.modules.health.entity.work.reform.vo;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 风险化解情况统计清单
 *
 * @author zhangxu
 * @since 2024-05-08
 */
@Data
@Accessors(chain = true)
public class ComRiskCompletionStatisticsVo implements Serializable {
    private static final long serialVersionUID = 1234123423L;

    /**
     * 企业数量
     */
    private Integer comNum;

    /**
     * 申报已化解数量
     */
    private Integer declareCompleted;

    /**
     * 体检已化解数量
     */
    private Integer physicalCompleted;

    /**
     * 检测已化解数量
     */
    private Integer checkCompleted;

    /**
     * 培训已化解数量
     */
    private Integer trainingCompleted;

    /**
     * 三同时已化解数量
     */
    private Integer threeCompleted;

    /**
     * 个人防护用品已化解数量
     */
    private Integer protectCompleted;

    /**
     * 现场示警标识已化解数量
     */
    private Integer warnCompleted;

    /**
     * 职业卫生档案已化解数量
     */
    private Integer healthCompleted;

    private String declareRate;//申报化解率
    private String physicalRate;//体检化解率
    private String checkRate;//检测化解率
    private String trainingRate;//培训化解率
    private String threeRate;//三同时化解率
    private String protectRate;//个人防护用品化解率
    private String warnRate;//现场示警标识化解率
    private String healthRate;//职业卫生档案化解率
}

