package cn.smarthse.modules.health.entity.work.reform.param;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author 覃浩云 1770126791@qq.com
 * @version 1.0
 * @description 风险化解结果验收清单搜索参数
 * @date 2023/5/10 19:17
 */
@Data
@Accessors(chain = true)
public class RiskResolveResSearch implements Serializable {

    /**
     * 分页信息
     */
    private Integer limit;
    private Integer rows;
    private Integer page;

    /**
     * 系统部署来源SystemDeploymentSourceEnum
     */
    private Byte systemDeploymentSource;

    private Boolean isCurrent;

    public int getPageNum() {
        return this.page;
    }

    public int getPageSize() {
        if (limit != null) {
            return this.limit;
        }
        if (rows != null) {
            return this.rows;
        }
        return 10;
    }

    /**
     * 搜索类型  风险化解清单-0 其他风险清单-1 检测、体检及监测结果异常风险清单-2  8大项加4个其他风险-3
     */
    private Integer searchType;

    /**
     * 风险id(reform_item_basic）
     */
    private Long riskId;

    /**
     * 区域Id
     */
    private Long areaId;

    /**
     * 区域等级
     */
    private Byte areaLevel;

    /**
     * 直属企业类型（0-非直属，1-省直属，2-市属）
     */
    private Integer companyLevel;

    /**
     * 示警状态
     */
    private Byte warningStatus;

    /**
     * 整改状态
     */
    private Byte reformStatus;

    /**
     * 风险类型
     */
    private Byte riskType;
    private String riskTypeStr;
    private List<Integer> riskTypeStrList;

    /**
     * 风险类型(子项)
     */
    private Byte riskChildType;
    private String riskChildTypeStr;
    private List<Integer> riskChildTypeStrList;

    /**
     * 风险来源（ReformSourceLiteEnum，2024.2.28暂时只有这两个用画像来源查询合并数据basic表，服务管家查重复数据source表）
     */
    private Byte reformSource;

    /**
     * 乡镇协管首页查询
     */
    private Boolean isForXzxgHome = false;

    /**
     * 搜索关键词
     */
    private String keyWord;


    private Boolean pickupCount= false;//是否包含接害人数小于3的数据

    private Boolean isExistRadioactivity = false;//是否放射单位

    private Boolean containPausedBusiness = false;//是否包含暂停企业

    private Boolean isShowPushedRiskCenter = false;//是否仅显示推送到风险调度中心的数据

    /**
     * 分组名称
     */
    private String groupName;

    /**
     * 查询名称
     */
    private String queryName;

    /**
     * 优化营商环境减免行政处罚统计报表 - 排序依据 （1最多减免处罚成本 2至少减免处罚成本）
     */
    private Integer envSortBy;

    /**
     * 展示全部地市
     */
    private Boolean isCity = false;

    /**
     * 展示全部县区
     */
    private Boolean isCounty = false;

    /**
     * 是否各行政区划风险数量统计查询
     */
    private Boolean isRegionRiskStatistics;

    /**
     * 是否开启风险时间过滤参数
     */
    private Boolean enableRiskDateFilter;
    /**
     * 开始时间
     */
    private Date startDate;
    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 区划id列表入参
     */
    private List<Long> regionIdList;

    /**
     * 推送时间
     */
    private String pushDate;

    private Long cid;

    /**
     * 等于true的时候筛选出无需推送
     */
    private Boolean isNoPushRequired = false;

    private Integer year;

    /**
     * 是否分类对象 all,olddec,current,false,allCom所有企业
     */
    private String isClassified;

    /**
     * 是否粉尘一体化企业（1是 0否）
     */
    private Integer isFcImportanceCompany;

    /**
     * 在统计[全部市/全部区县]的：用人单位负责人培训率，用到了此字段。
     * 2：统计所有市
     * 3：统计所有区县
     */
    private Byte searchLevel;
}
