package cn.smarthse.modules.health.entity.work.reform.param;

import cn.smarthse.common.util.DateUtils;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 风险列表搜索参数
 *
 * @author ShenZQ
 * @since 2023/3/13 16:14
 */
@Data
public class RiskListSearch implements Serializable {

    private static final long serialVersionUID = -7533000663368852969L;

    private Long id;

    private Long acceptanceId;

    private Long cid;
    /**
     * 整改是否已超期（1、是；2、否）
     */
    private Byte searchOverdueStatus;
    /**
     * 验收是否已超期（1、是；2、否）
     */
    private Byte searchAccOverdueStatus;
    /**
     * 状态(草稿-0; 待整改-1; 待验收-2; 已完成-3; 无需整改-4; 退回-5; 监管忽略-6（已废弃）)
     */
    private Byte searchStatus;
    /**
     * 要求完成时间开始
     */
    public Date searchStartDate;
    /**
     * 要求完成时间结束
     */
    public Date searchEndDate;
    /**
     * 风险来源
     */
    private Integer searchSource;
    /**
     * 整改名称
     */
    private String searchKeywords;
    /**
     * 是否可以修改
     */
    private Boolean isEdit;
    /**
     * 基础信息ID集合
     */
    private List<Long> basicIds;
    /**
     * 预警状态
     *  1、首次推送（默认值）
     *  2、黄色预警（大于2个月未完成整改）
     *  3、红色预警（大于3个月未完成整改）
     *  4、启动执法（大于4个月）
     */
    private Byte warningState;

    /**
     * 根据年度查询
     */
    private Integer year;

    private Long areaId;

    private Byte areaLevel;

    /**
     * 推送时间
     */
    private String pushDate;
}
