package cn.smarthse.modules.health.entity.work.reform.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 风险整改验收参数
 * @author 郭强
 * @date 2023/3/14 14:59
 */
@Data
public class ReformRecordAcceptanceParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 风险id
     */
    @NotNull
    private Long reformItemId;

    /**
     * 验收负责人姓名
     */
    private String acceptanceDirectorName;

    /**
     * 验收佐证材料 附件ids
     */
    private String acceptanceFiles;

    /**
     * 状态 验收通过（已完成-1）; 验收不通过（未完成-0）
     */
    @NotNull
    private Byte acceptanceResult;

    /**
     * 不通过说明
     */
    private String acceptanceResultExplain;

    /**
     * 登陆用户id
     */
    private Long userId;

    /**
     * 用户姓名
     */
    private String fullName;

}
