package cn.smarthse.modules.health.entity.work.reform.param;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 东阳区域风险化解情况和巡查情况(DyAreaRiskCompletion)参数查询
 *
 * @author zhangxu
 * @since 2024-05-08
 */
@Data
@Accessors(chain = true)
public class DyAreaRiskParam implements Serializable {
    private static final long serialVersionUID = 201900981105157743L;

    /**
     * 区域id
     */
    private Long areaId;

    /**
     * 区域等级
     */
    private Byte areaLevel;

    /**
     * 接害人数：
     * 1->默认不勾选,展示接害人数≥3人或无数据企业的数据;
     * 2->勾选后，展示接害人数<3人+接害人数≥3人或无数据企业的数据;
     */
    private Integer pickupCount;

    /**
     * 企业状态：
     * 1->正常; 2->暂停营业; 0->关闭;
     * 12->正常+暂停营业;
     * 120->正常+暂停营业+关闭;
     */
    private Integer businessState;
    private String businessStateStr;
    private List<Integer> businessStateList;

    /**
     * 开始时间
     */
    private Date beginDate;

    /**
     * 结束时间/查询日期
     */
    private Date endDate;

    /**
     * 当日日期
     */
    private Date currDate;

    /**
     * 当月第一天日期
     */
    private Date monthFirstDate;

    /**
     * 是否正常暂停关闭的分开的数据
     */
    private Boolean isBusinessStateDetail = false;

    /**
     *  各种率是否只统计正常
     */
    private Boolean isRateInNormal = false;

    /**
     *
     */
    Map<String, Object> param;
}

