package cn.smarthse.modules.health.entity.work.reform;

import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 巡查化解率一览表历史记录
 */
@Table(name = "tm_reform_rate_table_history")
public @Data class TmReformRateTableHistory implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @Id
    private Long id;
    /**
     * 数据批次编号（年月日）
     */
    private String batchNo;
    /**
     * 本级管理企业：2（全部）；0-非本级；1-本级
     */
    private Integer thisLevel;
    /**
     * 区域id
     */
    private Long areaId;
    /**
     * 省id
     */
    private Long areaId1;
    /**
     * 市id
     */
    private Long areaId2;
    /**
     * 区id
     */
    private Long areaId3;
    /**
     * 街道id
     */
    private Long areaId4;
    /**
     * 区域等级
     */
    private Integer areaLevel;
    /**
     * 区域名称
     */
    private String areaName;
    /**
     * 需巡查正常营业企业数
     */
    private Integer needPatrolCompNum;
    /**
     * 已巡查企业数
     */
    private Integer patrolledCompNum;
    /**
     * 巡查覆盖率
     */
    private String patrolCoverRate;
    /**
     * 巡查化解率
     */
    private String patrolResolveRate;
    /**
     * 自查表提交率
     */
    private String selfCommitRate;
    /**
     * 数据所属年份
     */
    private Integer datasYear;

    private Date createDate;
    private Long createBy;
    private Date updateDate;
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

}
