package cn.smarthse.modules.health.entity.work.reform;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * 企业示警状态清单
 * risk_warning_status_list
 */
@Table(name = "risk_warning_status_list")
@Data
public class RiskWarningStatusList implements Serializable {
    /**
     * id
     */
    @Id
    private Long id;


    /**
     * 风险数量
     */
    private Integer riskNum;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    private Integer pickupCount;

    /**
     * 类型（0-为化解的数据，1-已化解的数据）
     */
    private Byte type;

    @Transient
    private static final long serialVersionUID = 1L;

    private String companyName;
    private Long cid;
    private int riskResolvedNum;
    @Column(name = "first_push_pum")
    private Integer firstPushNum;
    private Integer yellowAlertNum;
    private Integer redAlertNum;
    @Column(name = "exLaw_num")
    private Integer exLawNum;


    private Long provinceId;
    private Long cityId;
    private Long areaId;
    private Long streetId;

    private String provinceName;
    private String cityName;
    private String areaName;
    private String streetName;

    private Byte belongType;

}
