package cn.smarthse.modules.health.entity.work.reform;

import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 风险来源管理实体
 */
@Table(name = "risk_source")
public @Data
class RiskSource implements Serializable {

    /**
     * ID
     */
    @Id
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 整改生成类型来源
     */
    private Byte generationSource;

    /**
     * 整改项来源 ReformSourceLiteEnum 多个来源用逗号隔开
     */
    private String reformItemSources;

    /**
     * 定时任务更新数据时间
     */
    private Date schTaskUpdateDate;

    /**
     * 1、定时任务执行生成 2、调用接口生成
     */
    private Byte dataSource;

    private Date createDate;

    private Long createBy;

    private Date updateDate;

    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

}
