package cn.smarthse.modules.health.entity.work.reform;

import cn.smarthse.modules.health.enums.reform.ReformDataSourceEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * 风险化解-基础信息表(RiskResolutionBasic)表实体类
 *
 * @author Supw
 * @since 2024-01-29 09:22:10
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RiskResolutionBasic implements Serializable{
        @Id
        private Long id;
        //企业ID
        private Long cid;
        //机构id
        private Long thirdOrgId;
        //整改项名称
        private String name;
        //整改项发现人
        private Long finder;
        //隐患发现人姓名（冗余）
        private String finderName;
        //发现时间
        private Date findTime;
        //发现年份
        private Integer findYear;
        //整改项描述
        private String description;
        //整改项附件
        private String reformItemFiles;
        //状态(草稿-0; 待整改-1; 待验收-2; 已完成-3; 无需整改-4; 退回-5; 监管忽略-6（已废弃）) ReformStatusEnum
        private Byte status;
        //生成的整改项类型 ReformGenerationSourceEnum
        private Byte generationSource;
        //验收期限
        private Date requireAcceptanceTime;
        /**
         * 数据来源
         * @see ReformDataSourceEnum
         */
        private Byte dataSource;
        //预警状态（4-启动执法）
        private Byte lawStatus;
        //创建人
        private Long createBy;
        //创建时间
        private Date createDate;
        //最后修改人ID
        private Long updateBy;
        //最后修改时间
        private Date updateDate;
        //是否有效（0-无效，1-有效）
        private Boolean isValid;
        //省id
        private Long provinceId;
        //市id
        private Long cityId;
        //区id
        private Long areaId;
        //区街道id
        private Long streetId;


}

