package cn.smarthse.modules.health.entity.work.reform;

import java.util.Date;
import java.io.Serializable;
import lombok.Data;

import javax.persistence.Id;

/**
 * 风险化解-验收表(RiskResolutionAccept)表实体类
 *
 * @author Supw
 * @since 2024-01-29 09:21:58
 */
@Data
public class RiskResolutionAccept implements Serializable{
        @Id
        private Long id;
        //风险化解表id
        private Long riskBasicId;
        //企业ID
        private Long cid;
        //整改责任人
        private Long reformDirector;
        //整改负责人姓名（冗余）
        private String reformDirectorName;
        //整改协作人
        private String reformCollaborator;
        //整改协作人姓名（冗余）
        private String reformCollaboratorName;
        //要求完成时间
        private Date requireFinishTime;
        //实际完成时间
        private Date actualFinishTime;
        //整改方案
        private String reformSolution;
        //整改通知书
        private String reformNotification;
        //整改后相关资料
        private String reformFinishedFiles;
        //整改方案资料
        private String reformProgrammeFiles;
        //验收责任人
        private Long acceptanceDirector;
        //验收负责人姓名（冗余）
        private String acceptanceDirectorName;
        //验收参与人id，以逗号分隔
        private String acceptanceCollaborator;
        //验收协作人姓名（冗余）
        private String acceptanceCollaboratorName;
        //验收时间
        private Date acceptanceDate;
        //验收结论（1-通过；0-不通过）
        private Integer acceptanceResult;
        //验收结论说明
        private String acceptanceResultExplain;
        //验收相关资料
        private String acceptanceFiles;
        //状态（0、草稿；1、待审核；2-无需整改；3、完成 见枚举ReformAcceptanceRecordStatusEnum)
        private Byte status;
        //整改措施
        private String reformMeasure;
        //是否需要整改（是否入职）
        private Boolean isInduction;
        //处理措施
        private Integer dealMeasure;
        //自定义处理措施名称
        private String dealMeasureName;
        //情况说明
        private String situationDescription;
        //诊断/体检机构id
        private Long thirdOrgId;
        //诊断/体检机构名称
        private String thirdOrgName;
        //诊断、体检时间开始
        private Date dealTimeBegin;
        //诊断、体检时间结束
        private Date dealTimeEnd;
        //创建时间
        private Date createDate;
        //创建人
        private Long createBy;
        //最后修改时间
        private Date updateDate;
        //最后修改人ID
        private Long updateBy;
        //是否有效（0-无效，1-有效）
        private Boolean isValid;


}

