package cn.smarthse.modules.health.entity.work.reform;


import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceChildEnum;
import cn.smarthse.modules.health.enums.reform.ReformDataSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 整改项多数据源表(ReformItemSource)表实体类
 *
 * @author zhangxu
 * @since 2024-02-04
 */
@Data
@Accessors(chain = true)
@SuppressWarnings("serial")
public class ReformItemSource implements Serializable {

    private static final long serialVersionUID = -41409671529980941L;

    @Id
    @Column(name = "id")
    private Long id;

    /**
     * basic.id
     */
    @Column(name = "reform_item_id")
    private Long reformItemId;

    /**
     * 企业ID
     */
    @Column(name = "cid")
    private Long cid;

    /**
     * 机构id
     */
    @Column(name = "third_org_id")
    private Long thirdOrgId;

    /**
     * 整改发现人姓名（冗余）
     */
    @Column(name = "finder_name")
    private String finderName;

    /**
     * 发现时间
     */
    @Column(name = "find_time")
    private Date findTime;

    /**
     * 整改项名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 整改项来源 ReformSourceLiteEnum
     */
    @Column(name = "reform_item_source")
    private Byte reformItemSource;

    /**
     * 整改项来源业务id
     */
    @Column(name = "reform_item_source_id")
    private Long reformItemSourceId;

    /**
     * 体检整改项跳转id（有才填）
     */
    @Column(name = "tj_business_id")
    private String tjBusinessId;


    /**
     * 生成的整改项类型 ReformGenerationSourceEnum
     */
    @Column(name = "generation_source")
    private Byte generationSource;

    /**
     * 生成的整改项类型generationSource的子项
     * @see  ReformGenerationSourceChildEnum
     */
    @Column(name = "reform_item_source_type")
    private Byte reformItemSourceType;

    /**
     * 整改项描述
     */
    @Column(name = "description")
    private String description;

    /**
     * 整改项附件(有几十条在用，应该可以不要)
     */
    @Column(name = "reform_item_files")
    private String reformItemFiles;

    /**
     * 验收期限
     */
    @Column(name = "require_acceptance_time")
    private Date requireAcceptanceTime;

    /**
     * 状态 ReformStatusEnum
     */
    @Column(name = "status")
    private Byte status;

    /**
     * 预警状态（4-启动执法）
     */
    @Column(name = "law_status")
    private Byte lawStatus;

    /**
     * 行政区划(取企业当时的行政区划)
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     * 省id
     */
    @Column(name = "area_id1")
    private Long areaId1;

    /**
     * 市id
     */
    @Column(name = "area_id2")
    private Long areaId2;

    /**
     * 区id
     */
    @Column(name = "area_id3")
    private Long areaId3;

    /**
     * 区街道id
     */
    @Column(name = "area_id4")
    private Long areaId4;

    /**
     * 实际完成时间(冗余)
     */
    @Column(name = "actual_finish_time")
    private Date actualFinishTime;

    /**
     * 整改责任人(冗余)
     */
    @Column(name = "reform_director_name")
    private String reformDirectorName;

    /**
     * 验收时间(冗余)
     */
    @Column(name = "acceptance_date")
    private Date acceptanceDate;

    /**
     * 验收负责人姓名（冗余）
     */
    @Column(name = "acceptance_director_name")
    private String acceptanceDirectorName;

    /**
     * 数据来源
     * @see ReformDataSourceEnum
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 整改批次（23年查询用）
     */
    @Column(name = "batch_num")
    private Integer batchNum = 1;

    /**
     * 是否在整改模块列表显示 （23年查询用）
     */
    @Column(name = "is_show_in_reform_modular")
    private Boolean isShowInReformModular = true;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;


    //--------------------------------以下是非数据库的字段---------------------

    @Transient
    private String companyName;
    /**
     * 验收信息
     */
    @Transient
    private ReformItemAcceptanceRecord acceptance;
    @Transient
    private List<ReformItemAcceptanceRecord> aceptanceList = new ArrayList<ReformItemAcceptanceRecord>();

    @Transient
    private String reformMeasures;

    @Transient
    private Byte warningState;

    @Transient
    private String findTimeStr;

    /**
     * 识别时间（生成创建时间）
     */
    @Transient
    private String createDateStr;

    @Transient
    private String generationSourceStr;

    /**
     * 整改项附件列表
     */
    @Transient
    private List<SysFileModel> finishFileList;

    /**
     * 整改项附件列表
     */
    @Transient
    private List<SysFileModel> reformItemFileList;

    /**
     * 验收附件列表
     */
    @Transient
    private List<SysFileModel> acceptanceFileList;


    public void setFindTime(Date findTime) {
        if (findTime==null){
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        this.findTimeStr = format.format(findTime);
        this.findTime = findTime;
    }

    public void setCreateDate(Date createDate) {
        if (createDate!=null){
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.createDateStr = format.format(createDate);
        }
        this.createDate = createDate;
    }

    public ReformItemAcceptanceRecord getAcceptance() {
        if(acceptance!=null){
            return acceptance;
        }
        if(this.aceptanceList !=null && !this.aceptanceList.isEmpty() && this.aceptanceList.size()>0){
            return getAceptanceList().get(0);
        }
        return acceptance;
    }

    public void setGenerationSource(Byte generationSource) {
        String name = ReformGenerationSourceEnum.getNameByValue(generationSource);
        if (StringUtils.isEmpty(name)) {
            name = "其他";
        }
        this.generationSourceStr = name;
        this.generationSource = generationSource;
    }








    //--------------------------------todo 下面的数据库字段应该是不需要的---------------------


    /**
     * 整改项发现人
     */
    @Column(name = "finder")
    private Long finder;

    /**
     * 有父id的整改项是验收不通过的新增整改项
     */
    @Column(name = "pid")
    private Long pid;

    /**
     * 组织部门id
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 整改项位置
     */
    @Column(name = "reform_item_position")
    private Long reformItemPosition;

    /**
     * 整改项位置名称
     */
    @Column(name = "reform_item_position_name")
    private String reformItemPositionName;

    /**
     * 整改项分级
     */
    @Column(name = "reform_item_level")
    private Byte reformItemLevel;

    /**
     * 整改项分类
     */
    @Column(name = "reform_item_type")
    private Byte reformItemType;

    /**
     * 业务总状态
     */
    @Column(name = "business_status")
    private Byte businessStatus;

    /**
     * 危害因素检测状态，1：正常；0：忽略
     */
    @Column(name = "harm_factor_status")
    private Byte harmFactorStatus;

    /**
     * 整改项编号
     */
    @Column(name = "reform_item_sn")
    private String reformItemSn;

    /**
     * ????֪ͨ?
     */
    @Column(name = "reform_notification")
    private String reformNotification;

    /**
     * 编辑者
     */
    @Column(name = "editor")
    private Long editor;

    /**
     * 是否自动生成的整改项
     */
    @Column(name = "is_auto_generation")
    private Boolean isAutoGeneration;

    /**
     * 被退回原因
     */
    @Column(name = "back_reason")
    private String backReason;

    /**
     * 验收对象（1、企业内部；2、监管部门；3、第三方托管对象)
     */
    @Column(name = "acceptance_object")
    private Byte acceptanceObject;

    /**
     * 是否在整改模块列表显示(乡镇协管页面)
     */
    @Column(name = "is_show_in_reform_xzxg")
    private Boolean isShowInReformXzxg;
}
