package cn.smarthse.modules.health.entity.work.reform;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "reform_item_message_receiver")
public class ReformItemMessageReceiver implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 消息接收者ID（员工ID）
     */
    private Long reveiver;

    /**
     * 业务ID
     */
    @Column(name = "business_id")
    private Long businessId;

    /**
     * 状态（0、存草稿；8、已发送，见枚举StatusEnum)
     */
    private Byte status;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取消息接收者ID（员工ID）
     *
     * @return reveiver - 消息接收者ID（员工ID）
     */
    public Long getReveiver() {
        return reveiver;
    }

    /**
     * 设置消息接收者ID（员工ID）
     *
     * @param reveiver 消息接收者ID（员工ID）
     */
    public void setReveiver(Long reveiver) {
        this.reveiver = reveiver;
    }

    /**
     * 获取业务ID
     *
     * @return business_id - 业务ID
     */
    public Long getBusinessId() {
        return businessId;
    }

    /**
     * 设置业务ID
     *
     * @param businessId 业务ID
     */
    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    /**
     * 获取状态（0、存草稿；8、已发送，见枚举StatusEnum)
     *
     * @return status - 状态（0、存草稿；8、已发送，见枚举StatusEnum)
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态（0、存草稿；8、已发送，见枚举StatusEnum)
     *
     * @param status 状态（0、存草稿；8、已发送，见枚举StatusEnum)
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}