package cn.smarthse.modules.health.entity.work.reform;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.sys.message.Message;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@Accessors(chain = true)
@Table(name = "reform_item_acceptance_record")
public class ReformItemAcceptanceRecord implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * basic.id
     */
    @Column(name = "reform_item_id")
    private Long reformItemId;

    /**
     * 企业ID
     */
    private Long cid;
    
    /**
     * 整改负责人姓名（冗余）
     */
    @Column(name = "reform_director_name")
    private String reformDirectorName;

    /**
     * 要求完成时间
     */
    @Column(name = "require_finish_time")
    private Date requireFinishTime;

    /**
     * 实际完成时间
     */
    @Column(name = "actual_finish_time")
    private Date actualFinishTime;

    /**
     * 整改措施
     */
    @Column(name = "reform_measure")
    private String reformMeasure;

    /**
     * 整改相关资料
     */
    @Column(name = "reform_finished_files")
    private String reformFinishedFiles;

    /**
     * 状态ReformAcceptanceRecordStatusEnum
     */
    private Byte status;

    /**
     * 验收负责人姓名（冗余）
     */
    @Column(name = "acceptance_director_name")
    private String acceptanceDirectorName;

    /**
     * 验收时间
     */
    @Column(name = "acceptance_date")
    private Date acceptanceDate;

    /**
     * 验收结论
     */
    @Column(name = "acceptance_result")
    private Byte acceptanceResult;

    /**
     * 验收结论说明
     */
    @Column(name = "acceptance_result_explain")
    private String acceptanceResultExplain;

    /**
     * 验收相关资料
     */
    @Column(name = "acceptance_files")
    private String acceptanceFiles;

    /**
     * 最近一次职业健康体检机构名称/最近一次定期检测机构名称
     */
    @Column(name = "third_org_id")
    private Long thirdOrgId;

    /**
     * 最近一次职业健康体检机构名称/最近一次定期检测机构名称
     */
    @Column(name = "third_org_name")
    private String thirdOrgName;

    /**
     * 最近一次在岗期间体检时间/最近一次定期检测时间
     */
    @Column(name = "deal_time_begin")
    private Date dealTimeBegin;

    /**
     * 处理措施
     */
    @Column(name = "deal_measure")
    private Byte dealMeasure;

    /**
     * 自定义处理措施名称
     */
    @Column(name = "deal_measure_name")
    private String dealMeasureName;

    /**
     * 诊断时间/复查时间(好像没用到，不知道那一次提到这里来了)
     */
    @Column(name = "deal_time_end")
    private Date dealTimeEnd;

    /**
     * 整改方案资料(疑似职业病添加必填项)
     */
    @Column(name = "reform_programme_files")
    private String reformProgrammeFiles;


    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;


    /**
     * 体检作证材料化解整改方案
     * -1当前无需开展职业健康检测
     * 0已按要求开展职业健康检查
     * 1仅存在噪声且均未超过85分贝
     * 2当前接害人员全部为新入职员工，已开展上岗前职业健康检查
     * 3仅接触放射性危害因素
     * 4仅接触体检周期2年及以上的其他危害因素
     * 5仅接触无职业健康检查标准或参考标准的危害因素
     * 6停工无法开展职业健康检查
     * 7当年接害岗位人员已全部离岗
     */
    @Column(name = "tj_reform_solution")
    private String tjReformSolution;

    /**
     * 停工，无法开展职业健康检查【下次开工日期】，必填项
     */
    @Column(name = "next_start_date")
    private Date nextStartDate;


    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    //--------------------------------以下是非数据库的字段---------------------

    /**
     * 验收相关资料文件列表
     */
    @Transient
    private List<SysFileModel> acceptanceFilesList;
    
    /**
     * 整改资料文件列表
     */
    @Transient
    private List<SysFileModel> reformFinishedFilesList;

    /**
     * 整改方案文件(疑似职业病添加必填项)
     */
    @Transient
    private List<SysFileModel> reformSolutionFilesList;

    @Transient
    private Byte generationSource;

    @Transient
    private ReformItemBasic reformItemBasic;

    /**
     * 检测超标整改措施是否是历史数据：如果没有历史数据都默认显示新的
     */
    @Transient
    private Boolean checkMeasureIsOld = true;

    public void setReformFinishedFiles(String reformFinishedFiles) {
        this.reformFinishedFiles = reformFinishedFiles == null ? null : reformFinishedFiles.trim();
    }

    public void setAcceptanceResultExplain(String acceptanceResultExplain) {
        this.acceptanceResultExplain = acceptanceResultExplain == null ? null : acceptanceResultExplain.trim();
    }

    public void setAcceptanceFiles(String acceptanceFiles) {
        this.acceptanceFiles = StringUtils.isBlank(acceptanceFiles) ? null : acceptanceFiles.trim();
    }

    public void setReformMeasure(String reformMeasure) {
        this.reformMeasure = reformMeasure == null ? null : reformMeasure.trim();
    }

    //--------------------------------todo 下面的数据库字段应该是不需要的---------------------

    /**
     * 验收责任人
     */
    @Column(name = "acceptance_director")
    private Long acceptanceDirector;

    /**
     * 整改通知书
     */
//    @DataValida(nullAble=false,name="整改通知书",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "reform_notification")
    private String reformNotification;

    /**
     * 整改方案
     */
    @Column(name = "reform_solution")
    private String reformSolution;

    /**
     * 整改协作人
     */
    @Column(name = "reform_collaborator")
    private String reformCollaborator;

    /**
     * 整改协作人姓名（冗余）
     */
    @Column(name = "reform_collaborator_name")
    private String reformCollaboratorName;

    /**
     * 整改责任人
     */
    @Column(name = "reform_director")
    private Long reformDirector;

    /**
     * 是否需要整改（是否入职）
     */
    @Column(name = "is_induction")
    private Boolean isInduction;

    /**
     * 情况说明
     */
    @Column(name = "situation_description")
    private String situationDescription;

    /**
     * 验收参与人
     */
    @Column(name = "acceptance_collaborator")
    private String acceptanceCollaborator;

    /**
     * 验收协作人姓名（冗余）
     */
    @Column(name = "acceptance_collaborator_name")
    private String acceptanceCollaboratorName;


    /**
     * 发送消息。如果为空就不发送，判断是否为空，用isMessageEmpty()；
     */
    @Transient
    private Message message;

    /**
     * 整改后资料文件列表
     */
    @Transient
    private List<SysFileModel> reformNotifyFilesList;

    /**
     * 设置整改协作人
     *
     * @param reformCollaborator 整改协作人
     */
    public void setReformCollaborator(String reformCollaborator) {
        this.reformCollaborator = reformCollaborator == null ? null : reformCollaborator.trim();
    }

    public boolean isEmpty(){
        if(this.getReformDirector()!=null){
            return false;
        }
        if(StringUtils.isNotEmpty(this.getReformCollaborator())){
            return false;
        }
        if(this.getRequireFinishTime()!=null){
            return false;
        }
        if(this.getReformSolution()!=null){
            return false;
        }
        if(this.getReformMeasure()!=null) {
            return false;
        }

        return true;
    }

    /**
     * 消息是否为空
     *
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年11月26日-下午4:31:38
     * @return
     */
    public boolean isMessageEmpty() {
        boolean isEmpty = true;
        if(this.message == null) {
            return isEmpty;
        }
        if(this.message.getReceivers().isEmpty()) {
            return isEmpty;
        }
        if(this.message.getReceivers().get(0).getReveiver()==null) {
            //消息接收者为空，则消息为空。（不存在给所有人发消息的情况。）
            return isEmpty;
        }

        isEmpty = false;
        return isEmpty;
    }
}