package cn.smarthse.modules.health.entity.work.reform;


import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 检测超标整改表的整改措施-详情表
 * </p>
 *
 * @author author
 * @since 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Table(name = "reform_check_measure")
public class ReformCheckMeasure implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @Id
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 检测id 历史数据没有存
     */
    private Long checkId;

    /**
     * 检测数据变化时间
     */
    private LocalDateTime changeTime;

    /**
     * 风险主表id
     */
    private Long reformId;

    /**
     * 验收表的id
     */
    private Long acceptRecordId;

    /**
     * 危害因素名称
     */
    private String factoryName;

    /**
     * 检测点位名称
     */
    private String pointName;

    /**
     * 检测点位名称--前端展示
     */
    @Transient
    private String pointNameStr;

    /**
     * 方案类型
     */
    private Integer type;

    /**
     * 方案内容
     */
    private String content;

    /**
     * 佐证材料
     */
    private String fileIds;

    /**
     * 处理情况  0未填写，1已填写，2系统智能处置-更新 3系统智能处置-删除  4（包含2，3）
     */
    private Integer situation;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 作证材料
     */
    @Transient
    private SysFileModel fileModel;

    @Transient
    private Boolean isBackFileModel = false;

    /**
     * 危害因素名称多选逗号拼接
     */
    @Transient
    private String factoryNames;

    /**
     * 处置情况多选逗号拼接
     */
    @Transient
    private String situations;

    @Transient
    private List<Long> ids;

    @Transient
    private List<Long> acceptRecordIds;

    @Transient
    private List<Long> reformIds;

    @Transient
    private List<Long> checkIds;

    @Transient
    private Boolean isOld;
}
