package cn.smarthse.modules.health.entity.work.reform;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * 东阳企业风险化解情况和巡查情况(DyComRiskCompletion)实体类
 *
 * @author zhangxu
 * @since 2024-05-10
 */
@Data
@Accessors(chain = true)
public class DyComRiskCompletion implements Serializable {
    private static final long serialVersionUID = -32740053780676881L;

    /**
     * id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select right(uuid_short(),19)")
    @Column(name = "id")
    private Long id;

    /**
     * 企业cid
     */
    @Column(name = "cid")
    private Long cid;

    /**
     * 区域id
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     * 风险总数
     */
    @Column(name = "risk_total_num")
    private Integer riskTotalNum;

    /**
     * 已化解风险总数
     */
    @Column(name = "risk_completed")
    private Integer riskCompleted;

    /**
     * 八项风险全部完成企业数
     */
    @Column(name = "com_all_completed")
    private Integer comAllCompleted;

    /**
     * 已巡查企业数
     */
    @Column(name = "com_patrol_num")
    private Integer comPatrolNum;

    /**
     * 巡查风险已化解企业数
     */
    @Column(name = "com_patrol_risk_defuse_num")
    private Integer comPatrolRiskDefuseNum;

    /**
     * 服务指导企业数
     */
    @Column(name = "com_guidance_num")
    private Integer comGuidanceNum;

    /**
     * 服务指导企业次数
     */
    @Column(name = "com_guidance_time_num")
    private Integer comGuidanceTimeNum;

    /**
     * 接害人数
     */
    @Column(name = "pickup_count")
    private Integer pickupCount;

    /**
     * 营业状态
     */
    @Column(name = "business_state")
    private Integer businessState;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
}

