package cn.smarthse.modules.health.entity.work.reform;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * @author Denglibin
 * @date 2021/12/17 15:46
 * @desc 检测整改项
 */
@Data
public class CheckPlanReformItem implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    private Long cid;//'企业ID',
    private Long checkId;//'检测id',
    private Date checkDateBegin;//'检测时间',
    private String checkWorkName;//'检测工作名称',
    private Long resultId;//'检测-判定结果id',
    private Long itemId;//'检测项目id（1化学因素 2粉尘 3噪声 其他）',
    private String checkPointName;//'检测点位名称',
    private String checkProject;//'检测项目（危害因素名称）',
    private Long factorId;//危害因素id


    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;


    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

}
