package cn.smarthse.modules.health.entity.work.planyear.vo;

import java.io.Serializable;
import java.util.Date;


import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import lombok.Data;

/**
 * 
 * 《年度计划>实施方案详细对象>用于同步业务模块对象》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-3-下午5:07:09
 */
public @Data class PlanYearSyncSO implements Serializable, Cloneable{
	private static final long serialVersionUID = 5838292016778096575L;

	
	/**
	 * 工作类型子类型
	 */
	private String workSubtype; 
	
	
	/**
	 * PlanYearDetail.id 年度计划详细内容ID
     */
    private Long detailId;
    
    /**
     *   企业编号
     */
    private Long cid;
    
    /**
     *   业务类型
     *   @see cn.smarthse.modules.health.entity.work.planyear.PlanYearModulars.modularCode
     */
    private String businesstype;
    
    /**
     * 业务模块ServiceBean名称
     * @see cn.smarthse.modules.health.entity.work.planyear.PlanYearModulars.modularBean
     */
    private String businessBean;
    
    /**
     *   工作名称
     */
    private String businessName;
    
    /**
     *   实施日期
     */
    private Date businessPlantime;
    
    /**
     *   负责人(部门/员工),Staff.ID
     */
    private Long managerId;
    
    /**
     *   创建员工(Staff.ID)
     */
    private Long creatorBy;
    
    
    /**
     * 权限部门
     */
    private Long orgId;
    
    
    /**
     * 关键工作消息提醒创建人(如果是无分解的直接是计划的创建人如果是分解则是执行人)
     */
    private Long tipCreateBy;
    
    /**
     *   工作内容(若无此项，可忽略）
     */
    private String businessContent;
    
   
    
    
    public Object clone() {   
        try {   
            return super.clone();   
        } catch (CloneNotSupportedException e) {   
            return null;   
        }   
    }

    /**
	 * 
	 */
	public PlanYearSyncSO() {
	} 
	
	/**
	 * 
	 * @param detail
	 */
	public PlanYearSyncSO(PlanYearDetail detail) {
		if(detail!=null){
			this.setCid(detail.getCid());									//企业编号
			this.setBusinessName(detail.getPlanWorkName());		//计划名称
			this.setBusinessPlantime(detail.getPlanImplDate());				//计划/实施时间
			//有父节点将计划阶段的负责人作为创建者（分解阶段）
			//无分解阶段直接是执行人
			if(detail.getDetailPid()!=null&&detail.getPlanManagerId()!=null) {
				this.setCreatorBy(detail.getPlanManagerId());					//创建人UserId
				this.setOrgId(detail.getPlanManagerOrgId());                //负责人对应的部门
				this.setManagerId(detail.getPlanManagerId());				//计划负责人
			}else {
				this.setCreatorBy(detail.getManagerId());			//创建人UserId
				this.setOrgId(detail.getOrgId());                   //权限所属为执行人的最初部门
				this.setManagerId(detail.getManagerId());				//计划负责人
			}
			//关键工作消息提醒创建人(如果是无分解的直接是计划的创建人如果是分解则是执行人)
			if(detail.getDetailPid()!=null) {
				this.setTipCreateBy(detail.getManagerId());  
			}else {
				this.setTipCreateBy(detail.getCreateBy());
			}
			
//			this.setCreatorBy(detail.getCreateBy());					//创建人UserId
			this.setDetailId(detail.getId());								//详细计划编号
		
			this.setBusinessContent(detail.getWorkContent());			//工作内容、可设置在备注
		}
		
	} 
}
