package cn.smarthse.modules.health.entity.work.planyear.vo;

import java.io.Serializable;
import java.util.Date;

import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import lombok.Data;

/**
 * 
 * 《年度计划同步更新年度实施方案的实施结果入参对象》
 * 
 * cid				所属企业编号(必须)
 * businessType		业务模块类型(必须)
 * businessId		业务模块ID(必须)
 * implWorkName     实施工作名称(必须)
 * implManagerId	负责人(必须)
 * implStartDate	实施开始时间(必须)
 * implEndDate      实施结束时间(实施日期为时间段的必须要,为单时间的可为NULL)
 * implState		实施状态(必须)
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-10-19-上午9:46:41
 */
public @Data class PlanYearExecute implements Serializable, Cloneable{
	private static final long serialVersionUID = 5838292016778096575L;

	 /**
     *   企业编号
     */
    private Long cid;
    
    /**
     *   业务模块类型
     *   @see cn.smarthse.modules.health.entity.work.planyear.PlanYearModulars.modularCode
     */
    private String businessType;
    
    /**
     *   业务模块ID
     */
    private Long businessId;
    
    /**
     *   实施工作名称
     */
    private String implWorkName;
    
    /**
     *   负责人
     */
    private Long implManagerId;
    
    /**
     *   实施开始日期
     */
    private Date implStartDate;
    
    /**
     *   实施结束日期
     */
    private Date implEndDate;
    
    /**
     *   实施状态
     */
    private PlanYearDetailImplState implState;
    
}
