package cn.smarthse.modules.health.entity.work.planyear;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


/**
 * 《PreventionExpend》
 * 
 * 职业病防治经费登记表
 * @Project:  smarthse-entity
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi（肖奕)
 * @since 2019年10月11日-上午11:09:00
 */
@Table(name = "prevention_expend")
public @Data class PreventionExpend implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;


    /**
     * 工作名称
     */
    @Column(name = "work_name")
    private String workName;
    /**
     * 用途（企业自定义参数表）
     * @see cn.smarthse.modules.health.enums.planyear.PlanYearExpendTypeEnum
     */
    @Column(name = "expend_type")
    private Byte expendType;

    /**
     * 预算花费
     */
    @Column(name = "budget_money")
    private BigDecimal budgetMoney;

    /**
     * 实际花费
     */
    @Column(name = "actual_money")
    private BigDecimal actualMoney;
    
    /**
     * 负责人(部门/员工),Staff.ID
     */
    @Column(name = "manager_id")
    private Long managerId;
    /**
     * 负责人姓名(部门/员工),Staff.ID
     */
    @Column(name = "manager_name")
    private String managerName;
    
    /**
     * 负责部门
     */
    @Column(name = "manage_dept")
    private Long manageDept;
    /**
     * 负责部门名称
     */
    @Column(name = "manage_dept_name")
    private String manageDeptName;
    
    /**
     * 工作开始日期
     */
    @Column(name = "work_start_date")
    private Date workStartDate;

    /**
     * 工作结束日期
     */
    @Column(name = "work_end_date")
    private Date workEndDate;
    /**
     * 详情
     */
    private String content;

    /**
     * 备注
     */
    private String remark;
    /**
     * 是否完成（0未完成 1已完成）
     */
    @Column(name = "is_finish")
    private Boolean isFinish;
    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 组织部门id
     */
    @Column(name = "org_id")
    private Long orgId;
  
    

    private static final long serialVersionUID = 1L;
    
    /**
     * 创建人名称
     */
    @Transient
    private String createName;
    
    /**
     * 类型名
     */
    @Transient
    private String typeName;
    
    /**
     * 实施时间
     */
    @Transient
    private String planImplDate;
    
//    public void setTypeName() {
//    	
//    	if(this.getExpendType() != null){
//    		
//    		this.typeName = PlanYearExpendTypeEnum.getName(this.getExpendType().intValue());
//    	}
//	}
}