package cn.smarthse.modules.health.entity.work.planyear;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

/**
 * 
 * 《PlanYearUploadFile》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.9.2>
 * @Comments:  <年度计划上传文件>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "plan_year_upload_file")
public @Data class PlanYearUploadFile implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 年度计划id
     */
    @Column(name = "plan_year_id")
    private Long planYearId;

    /**
     * 附件id
     */
    @Column(name = "file_id")
    private Long fileId;

    /**
     * 类型(1-计划附件,2-总结附件,3日常计划附件,4分解计划附件,5防治经费附件)
     */
    @Column(name = "file_type")
    private Byte fileType;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
    @Transient
    private SysFileModel file;
}