package cn.smarthse.modules.health.entity.work.planyear;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《年度计划实施方案工作类型表》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-4-上午10:42:07
 */
@Table(name = "plan_year_modulars")
public @Data class PlanYearModulars implements Serializable {
	private static final long serialVersionUID = -5131258581381577884L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 模块编码
     */
    @Column(name = "modular_code")
    private String modularCode;

    /**
     * 模块名称
     */
    @Column(name = "modular_name")
    private String modularName;

    /**
     * 模块ServiceBean
     */
    @Column(name = "modular_bean")
    private String modularBean;

    /**
     * 模块Url
     */
    @Column(name = "modular_url")
    private String modularUrl;

    /**
     * 模块图标
     */
    @Column(name = "modular_icon")
    private String modularIcon;

}