package cn.smarthse.modules.health.entity.work.planyear;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 
 * 《PlanYearExpend》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.9.2>
 * @Comments:  <年度计划预算>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "plan_year_expend")
public @Data class PlanYearExpend implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 年度计划id
     */
    @Column(name = "plan_year_id")
    private Long planYearId;

    /**
     * 用途（企业自定义参数表）
     * @see cn.smarthse.modules.health.enums.planyear.PlanYearExpendTypeEnum
     */
    @Column(name = "expend_type")
    private Byte expendType;

    /**
     * 预算花费
     */
    @Column(name = "budget_money")
    private BigDecimal budgetMoney;

    /**
     * 实际花费
     */
    @Column(name = "actual_money")
    private BigDecimal actualMoney;
    
    /**
     * 执行人(部门/员工),Staff.ID
     */
    @Column(name = "manager_id")
    private Long managerId;
    
    
    /**
     * 负责人(部门/员工),Staff.ID
     */
    @Column(name = "impl_manager_id")
    private Long implManagerId;

    /**
     * 详情
     */
    private String content;
    
    
    /**
     * (总结阶段)详情
     */
    @Column(name = "impl_content")
    private String implContent;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 1不分解，2分解
     */
    @Column(name = "decompose_status")
    private Byte decomposeStatus;

    /**
     * 执行人最初部门ID
     */
    @Column(name = "org_id")
    private Long orgId;
    
    @Column(name = "expend_pid")
    private Long expendPid;
    
    
    /**
     * 1 数据无更改  2 新增数据，3 修改数据 4 删除数据
     */
    @Column(name = "data_status")
    private Byte dataStatus;
    
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 负责人名称
     */
    @Transient
    private String staffName;
    
    /**
     * 类型名
     */
    @Transient
    private String typeName;
    
//    public void setTypeName() {
//    	
//    	if(this.getExpendType() != null){
//    		
//    		this.typeName = PlanYearExpendTypeEnum.getName(this.getExpendType().intValue());
//    	}
//	}
    /**
     *执行人ids
     */
    @Transient 
    private List<Long>  executorList;
    
    /**
     * 编制人姓名
     */
    @Transient
    private String updaterName;
    
    /**
     * 创建人姓名
     */
    @Transient
    private String creatorName;
    
    
    @Transient
    private String createTimeStr;
    @Transient
    private String updateTimeStr;
    @Transient
    private String decomposeStatusName;
    
    
    /**
     * 分配人名称
     */
    @Transient
    private String managerName;
    
    /**
     * 负责人名称
     */
    @Transient
    private String implManagerName;
    
    /**
     * 自己本身对应的工作计划
     */
    @Transient
    private PlanYear selfPlan;
    
    /**
     * 自己对应的父防治经费
     */
    @Transient
    private PlanYearExpend parentPlanExpend;
}