package cn.smarthse.modules.health.entity.work.planyear;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;

import lombok.Data;

/**
 * 
 * 《PlanYearDetail》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.9.2>
 * @Comments:  <年度计划详细计划>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "plan_year_detail")
public @Data class PlanYearDetail implements Serializable {
	private static final long serialVersionUID = 5728819205002244306L;
    
	/**
	 * 工作类型子类型
	 */
	@Column(name = "work_subtype")
	private String workSubtype;
	
	/**
	 * 实施时间（用于导出）
	 */
	@Transient
	private String implateDateStr;
	
	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 年度计划id
     */
    @Column(name = "plan_year_id")
    private Long planYearId;

    /**
     * 工作类别(plan_year_modulars.id)
     */
    @Column(name = "bussniss_modular_id")
    private Long bussnissModularId;

    /**
     * 业务编号(业务主表ID)
     */
    @Column(name = "bussniss_id")
    private Long bussnissId;

    /**
     * 计划工作名称
     */
    @Column(name = "plan_work_name")
    private String planWorkName;
    
    /**
     * 实施工作名称
     */
    @Column(name = "impl_work_name")
    private String implWorkName;

    /**
     * 工作内容
     */
    @Column(name = "work_content")
    private String workContent;
    
    /**
     * 实施工作内容
     */
    @Column(name = "impl_work_content")
    private String implWorkContent;

    /**
     * 分配人(部门/员工),Staff.ID
     */
    @Column(name = "manager_id")
    private Long managerId;
    
    /**
     * 负责人(部门/员工),Staff.ID
     */
    @Column(name = "impl_manager_id")
    private Long implManagerId;
    
    
    /**
     * 分解计划时计划阶段的负责人(部门/员工),Staff.ID
     */
    @Column(name = "plan_manager_id")
    private Long planManagerId;
    
    /**
     * 计划实施日期
     */
    @Column(name = "plan_impl_date")
    private Date planImplDate;
     
    
    /**
     * 计划实施日期
     */
    @Column(name = "plan_impl_date_end")
    private Date planImplDateEnd;
    /**
     * 实施开始日期
     */
    @Column(name = "impl_start_date")
    private Date implStartDate;
    
    /**
     * 实施结束日期
     */
    @Column(name = "impl_end_date")
    private Date implEndDate;

    /**
     * 实施结果(0-进行中,1-已完成,2-未实施)
     * @see cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState
     */
    @Column(name = "impl_result")
    private Byte implResult;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    
    /**
     * 1不分解，2分解
     */
    @Column(name = "decompose_status")
    private Byte decomposeStatus;
    
    /**
     * 执行人最初部门ID
     */
    @Column(name = "org_id")
    private Long orgId;
    
    /**
     * 父实施方案的Id
     */
    @Column(name = "detail_pid")
    private Long detailPid;
    
    /**
     * 提醒时间：1不提醒，2提前3天，3提前7天，4提前15天，5提前30天
     */
    @Column(name = "remind_time")
    private Byte remindTime;
    
    private String attachment;
    
    
    /**
     * 1 数据无更改  2 新增数据，3 修改数据 4 删除数据
     */
    @Column(name = "data_status")
    private Byte dataStatus;
    
    /**
     * 记录的转移人
     */
    @Column(name = "transfer_staff")
    private Long transferStaff;

    //===================数据属性定义=================================
    
    /**
     * 分配人名称
     */
    @Transient
    private String managerName;
    
    /**
     * 负责人名称
     */
    @Transient
    private String implManagerName;
    
    /**
     * 实施结果
     */
    @Transient
    private PlanYearDetailImplState implState;
    
    /**
     * 实施结果
     */
    @Transient
    private String implStateName;
    
    /**
     * 工作详细类型
     */
    @Transient
    private PlanYearModulars modular;
    
    /**
     *执行人ids
     */
    @Transient 
    private List<Long>  executorList;
    
    
    /**
     *计划实施时间字符串
     */
    @Transient
    private String planImplDateStr;
    
    /**
     * 具体实施时间字符串
     */
    @Transient
    private String implDateStr;
    
    /**
     * 
     */
    @Transient
    private Long[] attachmentArr;
    
    /**
     * 编制人姓名
     */
    @Transient
    private String updaterName;
    
    /**
     * 创建人姓名
     */
    @Transient
    private String creatorName;
    
    /**
     * 自己本身对应的工作计划
     */
    @Transient
    private PlanYear selfPlan;
    
    /**
     * 自己对应的父工作方案
     */
    @Transient
    private  PlanYearDetail parentPlanDetail;
    
    /**
     * 工作类型名字
     */
    @Transient
    private String workTypeName;
    @Transient
    private String createTimeStr;
    @Transient
    private String updateTimeStr;
    @Transient
    private String decomposeStatusName;

    
    /**
     * 子计划总结情况
     */
    @Transient
    private String childSummInfo;

    /**
     * 分解计划时计划阶段的负责人
     */
    @Transient
    private String planManagerName;
    
    /**
     * 判断当前登陆者是个人权限的话，执行人是否可编辑
     * 如果是执行人是创建者也可以编辑
     * 需要判断数据的创建者是执行人
     * 全厂和部门不是他创建的也可以编辑编辑
     */
    @Transient
    private Boolean  isPersonEdit;
    
    /**
     * 分解工作的负责人的部门ID（用于每个模块的数据）
     */
    @Transient
    private Long planManagerOrgId;

}