package cn.smarthse.modules.health.entity.work.planyear;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《PlanYear》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.9.2>
 * @Comments:  <年度计划>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "plan_year")
public @Data class PlanYear implements Serializable, Cloneable {
	private static final long serialVersionUID = 7988474677011419112L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 年度
     */
    @Column(name = "schedule_year")
    private String scheduleYear;

    /**
     * 计划名称
     */
    @Column(name = "plan_name")
    private String planName;

    /**
     * 计划内容
     */
    @Column(name = "plan_content")
    private String planContent;

    /**
     * 总结内容
     */
    @Column(name = "summary_content")
    private String summaryContent;

    /**
     * 阶段(1-计划,2-总结,3-完成)
     * @see cn.smarthse.modules.health.enums.planyear.PlanYearStageEnum
     */
    private Byte stage;
    
    
    /**
     *  完成（1） 计划完成作废(2) 总结作废完成（3）
     */
//    private Byte status;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 1年度工作计划 2 日常工作计划 3分解的工作的计划
     */
    @Column(name = "work_plan_type")
    private Byte workPlanType;

    /**
     * 父计划的id
     */
    @Column(name = "parent_plan_id")
    private Long parentPlanId;

    /**
     * 1年度工作计划 2 日常工作计划 3分解的工作的计划
     */
    @Column(name = "work_plan_source")
    private Byte workPlanSource;
    
    
    /**
     * 计划完成时间
     */
    @Column(name = "plan_complete_time")
    private Date planCompleteTime;
    
    
    @Column(name = "summary_complete_time")
    private Date summaryCompleteTime;
    
    
    /**
     * 1未变更  2已变更
     */
    @Column(name = "change_status")
    private Byte changeStatus;
    /**
     * 组织部门id
     */
    @Column(name = "org_id")
    private String orgId;
    
    /**
     * 编制人姓名
     */
    @Transient
    private String staffName;
    
    
    /**
     * 编辑实施方案中实施状态
     */
    @Transient
    private String[] detailId_status;
    
    /**
     * 当前登录者是否是编制人(1-是,0-不是)
     */
    @Transient
    private Byte isCreateBy;
    
    @Transient
    private List<PlanYearExpend>  planYearExpendList;
    
    /**
     *计划阶段的附件
     */
    @Transient
    private String planAttachmentStr;
    
    /**
     *计划阶段的附件
     */
    @Transient
    private  Long[] planAttachmentArr;
    /**
     * 总结阶段的附件
     */
    @Transient
    private String summaryAttachmentStr;
    /**
     * 总结阶段的附件
     */
    @Transient
    private Long[] summaryAttachmentArr;
    
    @Transient
    private  PlanYearDetail detail;
    
    /**
     * 类型名称
     */
    @Transient
    private String workPlanTypeName;
    
    /**
     * 来源
     */
    @Transient
    private String workPlanSourceName;
    
    
    @Transient
    private String createTimeStr;
    
    @Transient
    private String updateTimeStr;
    
    /**
     * 编制人姓名
     */
    @Transient
    private String updaterName;
    
    /**
     * 创建人姓名
     */
    @Transient
    private String creatorName;
    
    
    @Transient
    private PlanYearExpend  totalExpand;
    
    @Transient
    private String planCompleteTimeStr;
    
    
    @Transient
    private String summaryCompleteTimeStr;
    
    public Object clone() {   
        try {   
            return super.clone();   
        } catch (CloneNotSupportedException e) {   
            return null;   
        }   
    }
    
}