package cn.smarthse.modules.health.entity.work.planyear;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "plan_work_transfer_record")
public class PlanWorkTransferRecord implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 移交时间
     */
    @Column(name = "transfer_time")
    private Date transferTime;

    /**
     * 移交人
     */
    @Column(name = "transfer_staff")
    private Long transferStaff;

    /**
     * 接收人
     */
    @Column(name = "accept_staff")
    private Long acceptStaff;

    /**
     * 工作计划的id
     */
    @Column(name = "plan_id")
    private Long planId;

    /**
     * 是否有效(1-有效,0-无效)
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    /**
     * 接收人最初部门ID
     */
    @Column(name = "org_id")
    private Long orgId;
    
    @Transient
    private String  transferStaffName;
    
    @Transient
    private String  acceptStaffName;
    
    @Transient
    private String transferTimeStr;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取移交时间
     *
     * @return transfer_time - 移交时间
     */
    public Date getTransferTime() {
        return transferTime;
    }

    /**
     * 设置移交时间
     *
     * @param transferTime 移交时间
     */
    public void setTransferTime(Date transferTime) {
        this.transferTime = transferTime;
    }

    /**
     * 获取移交人
     *
     * @return transfer_staff - 移交人
     */
    public Long getTransferStaff() {
        return transferStaff;
    }

    /**
     * 设置移交人
     *
     * @param transferStaff 移交人
     */
    public void setTransferStaff(Long transferStaff) {
        this.transferStaff = transferStaff;
    }

    /**
     * 获取接收人
     *
     * @return accept_staff - 接收人
     */
    public Long getAcceptStaff() {
        return acceptStaff;
    }

    /**
     * 设置接收人
     *
     * @param acceptStaff 接收人
     */
    public void setAcceptStaff(Long acceptStaff) {
        this.acceptStaff = acceptStaff;
    }

    /**
     * 获取工作计划的id
     *
     * @return plan_id - 工作计划的id
     */
    public Long getPlanId() {
        return planId;
    }

    /**
     * 设置工作计划的id
     *
     * @param planId 工作计划的id
     */
    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    /**
     * 获取是否有效(1-有效,0-无效)
     *
     * @return is_valid - 是否有效(1-有效,0-无效)
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效(1-有效,0-无效)
     *
     * @param isValid 是否有效(1-有效,0-无效)
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public String getTransferStaffName() {
		return transferStaffName;
	}

	public void setTransferStaffName(String transferStaffName) {
		this.transferStaffName = transferStaffName;
	}

	public String getAcceptStaffName() {
		return acceptStaffName;
	}

	public void setAcceptStaffName(String acceptStaffName) {
		this.acceptStaffName = acceptStaffName;
	}

	public String getTransferTimeStr() {
		return transferTimeStr;
	}

	public void setTransferTimeStr(String transferTimeStr) {
		this.transferTimeStr = transferTimeStr;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}
}