package cn.smarthse.modules.health.entity.work.planyear;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "plan_work_executor_org_record")
public class PlanWorkExecutorOrgRecord implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 执行人
     */
    private Long executor;

    /**
     * 执行人最初部门ID
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 工作计划的id
     */
    @Column(name = "plan_id")
    private Long planId;
    
    /**
     * 1 实施方案，2预算经费
     */
    private Byte type;
    
    @Column(name = "plan_detail_or_expend_id")
    private Long planDetailOrExpendId;

    /**
     * 是否有效(1-有效,0-无效)
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取执行人
     *
     * @return executor - 执行人
     */
    public Long getExecutor() {
        return executor;
    }

    /**
     * 设置执行人
     *
     * @param executor 执行人
     */
    public void setExecutor(Long executor) {
        this.executor = executor;
    }

    /**
     * 获取执行人最初部门ID
     *
     * @return org_id - 执行人最初部门ID
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 设置执行人最初部门ID
     *
     * @param orgId 执行人最初部门ID
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 获取工作计划的id
     *
     * @return plan_id - 工作计划的id
     */
    public Long getPlanId() {
        return planId;
    }

    /**
     * 设置工作计划的id
     *
     * @param planId 工作计划的id
     */
    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    /**
     * 获取是否有效(1-有效,0-无效)
     *
     * @return is_valid - 是否有效(1-有效,0-无效)
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效(1-有效,0-无效)
     *
     * @param isValid 是否有效(1-有效,0-无效)
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public Byte getType() {
		return type;
	}

	public void setType(Byte type) {
		this.type = type;
	}

	public Long getPlanDetailOrExpendId() {
		return planDetailOrExpendId;
	}

	public void setPlanDetailOrExpendId(Long planDetailOrExpendId) {
		this.planDetailOrExpendId = planDetailOrExpendId;
	}
}