package cn.smarthse.modules.health.entity.work.pdmonitor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

@Table(name = "pd_monitor_check")
public @Data class PdMonitorCheck implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 工作编号
     */
    @Column(name = "work_no")
    private String workNo;

    /**
     * 工作名称
     */
    @Column(name = "work_name")
    private String workName;

    /**
     * 调查负责人
     */
    @Column(name = "check_leader_sid")
    private Long checkLeaderSid;

    /**
     * 调查负责人(雍余列)
     */
    @Column(name = "check_leader_name")
    private String checkLeaderName;

    /**
     * 被调查人
     */
    @Column(name = "informant_sid")
    private Long informantSid;

    /**
     * 被调查人(雍余列)
     */
    @Column(name = "informant_name")
    private String informantName;

    /**
     * 本次监测编号
     */
    @Column(name = "monitor_no")
    private String monitorNo;
    @Transient
    private String serviceName;
    /**
     * 监测结果异常原因
            1：个人剂量计异常
            2：人员接触时间过长
            3：人员操作失误
            4：出现应急处置操作
            5：设备防护异常
     */
    @Column(name = "monitor_exception_reason")
    private String monitorExceptionReason;

    /**
     * 剂量计佩带开始日期
     */
    @Column(name = "do_wear_start_time")
    private Date doWearStartTime;

    /**
     * 剂量计佩带结束日期
     */
    @Column(name = "do_wear_end_time")
    private Date doWearEndTime;

    /**
     * 调查水平剂量（mSv）
     */
    @Column(name = "check_dose")
    private BigDecimal checkDose;

    /**
     * 剂量读数（mSv）hp10
     */
    private BigDecimal hp10;

    /**
     * 剂量读数（mSv）hp07
     */
    private BigDecimal hp07;

    /**
     * 剂量读数（mSv）hp3
     */
    private BigDecimal hp3;

    /**
     * 调查结论
     */
    @Column(name = "check_conclusion")
    private String checkConclusion;

    /**
     * 大剂量调查和处理相关资料(file.id  多个文件)
     */
    @Column(name = "check_process_fids")
    private String checkProcessFids;

    /**
     * 大剂量调查和处理相关资料原件存放位置
     */
    @Column(name = "check_process_location")
    private String checkProcessLocation;

    /**
     * 完成时间
     */
    @Column(name = "finish_date")
    private Date finishDate;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private String orgId;
    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取工作编号
     *
     * @return work_no - 工作编号
     */
    public String getWorkNo() {
        return workNo;
    }

    /**
     * 设置工作编号
     *
     * @param workNo 工作编号
     */
    public void setWorkNo(String workNo) {
        this.workNo = workNo == null ? null : workNo.trim();
    }

    /**
     * 获取工作名称
     *
     * @return work_name - 工作名称
     */
    public String getWorkName() {
        return workName;
    }

    /**
     * 设置工作名称
     *
     * @param workName 工作名称
     */
    public void setWorkName(String workName) {
        this.workName = workName == null ? null : workName.trim();
    }

    /**
     * 获取调查负责人
     *
     * @return check_leader_sid - 调查负责人
     */
    public Long getCheckLeaderSid() {
        return checkLeaderSid;
    }

    /**
     * 设置调查负责人
     *
     * @param checkLeaderSid 调查负责人
     */
    public void setCheckLeaderSid(Long checkLeaderSid) {
        this.checkLeaderSid = checkLeaderSid;
    }

    /**
     * 获取调查负责人(雍余列)
     *
     * @return check_leader_name - 调查负责人(雍余列)
     */
    public String getCheckLeaderName() {
        return checkLeaderName;
    }

    /**
     * 设置调查负责人(雍余列)
     *
     * @param checkLeaderName 调查负责人(雍余列)
     */
    public void setCheckLeaderName(String checkLeaderName) {
        this.checkLeaderName = checkLeaderName == null ? null : checkLeaderName.trim();
    }

    /**
     * 获取被调查人
     *
     * @return informant_sid - 被调查人
     */
    public Long getInformantSid() {
        return informantSid;
    }

    /**
     * 设置被调查人
     *
     * @param informantSid 被调查人
     */
    public void setInformantSid(Long informantSid) {
        this.informantSid = informantSid;
    }

    /**
     * 获取被调查人(雍余列)
     *
     * @return informant_name - 被调查人(雍余列)
     */
    public String getInformantName() {
        return informantName;
    }

    /**
     * 设置被调查人(雍余列)
     *
     * @param informantName 被调查人(雍余列)
     */
    public void setInformantName(String informantName) {
        this.informantName = informantName == null ? null : informantName.trim();
    }

    /**
     * 获取本次监测编号
     *
     * @return monitor_no - 本次监测编号
     */
    public String getMonitorNo() {
        return monitorNo;
    }

    /**
     * 设置本次监测编号
     *
     * @param monitorNo 本次监测编号
     */
    public void setMonitorNo(String monitorNo) {
        this.monitorNo = monitorNo == null ? null : monitorNo.trim();
    }

    /**
     * 获取监测结果异常原因
            1：个人剂量计异常
            2：人员接触时间过长
            3：人员操作失误
            4：出现应急处置操作
            5：设备防护异常
     *
     * @return monitor_exception_reason - 监测结果异常原因
            1：个人剂量计异常
            2：人员接触时间过长
            3：人员操作失误
            4：出现应急处置操作
            5：设备防护异常
     */
    public String getMonitorExceptionReason() {
        return monitorExceptionReason;
    }

    /**
     * 设置监测结果异常原因
            1：个人剂量计异常
            2：人员接触时间过长
            3：人员操作失误
            4：出现应急处置操作
            5：设备防护异常
     *
     * @param monitorExceptionReason 监测结果异常原因
            1：个人剂量计异常
            2：人员接触时间过长
            3：人员操作失误
            4：出现应急处置操作
            5：设备防护异常
     */
    public void setMonitorExceptionReason(String monitorExceptionReason) {
        this.monitorExceptionReason = monitorExceptionReason == null ? null : monitorExceptionReason.trim();
    }

    /**
     * 获取剂量计佩带开始日期
     *
     * @return do_wear_start_time - 剂量计佩带开始日期
     */
    public Date getDoWearStartTime() {
        return doWearStartTime;
    }

    /**
     * 设置剂量计佩带开始日期
     *
     * @param doWearStartTime 剂量计佩带开始日期
     */
    public void setDoWearStartTime(Date doWearStartTime) {
        this.doWearStartTime = doWearStartTime;
    }

    /**
     * 获取剂量计佩带结束日期
     *
     * @return do_wear_end_time - 剂量计佩带结束日期
     */
    public Date getDoWearEndTime() {
        return doWearEndTime;
    }

    /**
     * 设置剂量计佩带结束日期
     *
     * @param doWearEndTime 剂量计佩带结束日期
     */
    public void setDoWearEndTime(Date doWearEndTime) {
        this.doWearEndTime = doWearEndTime;
    }

    /**
     * 获取调查水平剂量（mSv）
     *
     * @return check_dose - 调查水平剂量（mSv）
     */
    public BigDecimal getCheckDose() {
        return checkDose;
    }

    /**
     * 设置调查水平剂量（mSv）
     *
     * @param checkDose 调查水平剂量（mSv）
     */
    public void setCheckDose(BigDecimal checkDose) {
        this.checkDose = checkDose;
    }

    /**
     * 获取剂量读数（mSv）hp10
     *
     * @return hp10 - 剂量读数（mSv）hp10
     */
    public BigDecimal getHp10() {
        return hp10;
    }

    /**
     * 设置剂量读数（mSv）hp10
     *
     * @param hp10 剂量读数（mSv）hp10
     */
    public void setHp10(BigDecimal hp10) {
        this.hp10 = hp10;
    }

    /**
     * 获取剂量读数（mSv）hp07
     *
     * @return hp07 - 剂量读数（mSv）hp07
     */
    public BigDecimal getHp07() {
        return hp07;
    }

    /**
     * 设置剂量读数（mSv）hp07
     *
     * @param hp07 剂量读数（mSv）hp07
     */
    public void setHp07(BigDecimal hp07) {
        this.hp07 = hp07;
    }

    /**
     * 获取剂量读数（mSv）hp3
     *
     * @return hp3 - 剂量读数（mSv）hp3
     */
    public BigDecimal getHp3() {
        return hp3;
    }

    /**
     * 设置剂量读数（mSv）hp3
     *
     * @param hp3 剂量读数（mSv）hp3
     */
    public void setHp3(BigDecimal hp3) {
        this.hp3 = hp3;
    }

    /**
     * 获取调查结论
     *
     * @return check_conclusion - 调查结论
     */
    public String getCheckConclusion() {
        return checkConclusion;
    }

    /**
     * 设置调查结论
     *
     * @param checkConclusion 调查结论
     */
    public void setCheckConclusion(String checkConclusion) {
        this.checkConclusion = checkConclusion == null ? null : checkConclusion.trim();
    }

    /**
     * 获取大剂量调查和处理相关资料(file.id  多个文件)
     *
     * @return check_process_fids - 大剂量调查和处理相关资料(file.id  多个文件)
     */
    public String getCheckProcessFids() {
        return checkProcessFids;
    }

    /**
     * 设置大剂量调查和处理相关资料(file.id  多个文件)
     *
     * @param checkProcessFids 大剂量调查和处理相关资料(file.id  多个文件)
     */
    public void setCheckProcessFids(String checkProcessFids) {
        this.checkProcessFids = checkProcessFids == null ? null : checkProcessFids.trim();
    }

    /**
     * 获取大剂量调查和处理相关资料原件存放位置
     *
     * @return check_process_location - 大剂量调查和处理相关资料原件存放位置
     */
    public String getCheckProcessLocation() {
        return checkProcessLocation;
    }

    /**
     * 设置大剂量调查和处理相关资料原件存放位置
     *
     * @param checkProcessLocation 大剂量调查和处理相关资料原件存放位置
     */
    public void setCheckProcessLocation(String checkProcessLocation) {
        this.checkProcessLocation = checkProcessLocation == null ? null : checkProcessLocation.trim();
    }

    /**
     * 获取完成时间
     *
     * @return finish_date - 完成时间
     */
    public Date getFinishDate() {
        return finishDate;
    }

    /**
     * 设置完成时间
     *
     * @param finishDate 完成时间
     */
    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}