package cn.smarthse.modules.health.entity.work.pdmonitor;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "pd_monitor")
public  @Data class PdMonitor implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 工作名称
     */
    @Column(name = "work_name")
    private String workName;

    /**
     * 工作编号
     */
    @Column(name = "work_no")
    private String workNo;

    /**
     * 监测开始时间
     */
    @Column(name = "monitor_start_time")
    private Date monitorStartTime;

    /**
     * 监测结束时间
     */
    @Column(name = "monitor_end_time")
    private Date monitorEndTime;

    /**
     * 负责人
     */
    @Column(name = "leader_sid")
    private Long leaderSid;

    /**
     * 负责人姓名(雍余字段)
     */
    @Column(name = "leader_name")
    private String leaderName;

    /**
     * 服务机构的名称(tp_company.id)
     */
    @Column(name = "service_cid")
    private Long serviceCid;
    @Transient
    private String serviceCName;

    /**
     * 监测委托书/合同
     */
    @Column(name = "proxy_contract")
    private String proxyContract;

    /**
     * 监测委托书/合同原件存放位置（监测委托书/合同）
     */
    @Column(name = "proxy_contract_location")
    private String proxyContractLocation;

    /**
     * 监测报告(file.id  多附件形式)
     */
    @Column(name = "monitor_report")
    private String monitorReport;

    /**
     * 监测报告原件存放位置（监测报告）
     */
    @Column(name = "monitor_report_location")
    private String monitorReportLocation;

    /**
     * 归档时间
     */
    @Column(name = "archive_time")
    private Date archiveTime;
    @Transient
    private Date archiveTime2;//用于传递搜索条件
    
    /**
     * 是否作废
     */
    @Column(name = "is_void")
    private Boolean isVoid;
    @Transient
    private Boolean isFinish;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private String orgId;
    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

	public void setArchiveTime(Date archiveTime) {
		if(archiveTime!=null) {
			this.isFinish = true;
		}else {
			this.isFinish = false;
		}
		this.archiveTime = archiveTime;
	}
    
    

}