package cn.smarthse.modules.health.entity.work.operate;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

@Table(name = "work_operate_log")
@Data
public class WorkOperateLog implements Serializable {
    /**
     * ID
     */
    @Id
    private Long id;

    /**
     * 来源模块
     */
    @Column(name = "work_module")
    private Byte workModule;

    /**
     * 来源业务ID
     */
    @Column(name = "work_id")
    private Long workId;

    /**
     * 状态：1提交、2退回
     */
    @Column(name = "work_status")
    private Byte workStatus;

    /**
     * 原因
     */
    private String reason;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 操作人
     */
    private String operater;

    /**
     * 所在企业
     */
    @Column(name = "company_name")
    private  String companyName;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;


    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取来源模块
     *
     * @return work_module - 来源模块
     */
    public Byte getWorkModule() {
        return workModule;
    }

    /**
     * 设置来源模块
     *
     * @param workModule 来源模块
     */
    public void setWorkModule(Byte workModule) {
        this.workModule = workModule;
    }

    /**
     * 获取来源业务ID
     *
     * @return work_id - 来源业务ID
     */
    public Long getWorkId() {
        return workId;
    }

    /**
     * 设置来源业务ID
     *
     * @param workId 来源业务ID
     */
    public void setWorkId(Long workId) {
        this.workId = workId;
    }

    /**
     * 获取状态：1提交、2退回
     *
     * @return work_status - 状态：1提交、2退回
     */
    public Byte getWorkStatus() {
        return workStatus;
    }

    /**
     * 设置状态：1提交、2退回
     *
     * @param workStatus 状态：1提交、2退回
     */
    public void setWorkStatus(Byte workStatus) {
        this.workStatus = workStatus;
    }

    /**
     * 获取原因
     *
     * @return reason - 原因
     */
    public String getReason() {
        return reason;
    }

    /**
     * 设置原因
     *
     * @param reason 原因
     */
    public void setReason(String reason) {
        this.reason = reason == null ? null : reason.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取操作人
     *
     * @return operater - 操作人
     */
    public String getOperater() {
        return operater;
    }

    /**
     * 设置操作人
     *
     * @param operater 操作人
     */
    public void setOperater(String operater) {
        this.operater = operater == null ? null : operater.trim();
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public WorkOperateLog() {}

    public WorkOperateLog(Long id, Byte workModule, Long workId, Byte workStatus, String reason, Date createDate, String operater, Long createBy, Date updateDate, Long updateBy,String companyName) {
        this.id = id;
        this.workModule = workModule;
        this.workId = workId;
        this.workStatus = workStatus;
        this.reason = reason;
        this.createDate = createDate;
        this.operater = operater;
        this.createBy = createBy;
        this.updateDate = updateDate;
        this.updateBy = updateBy;
        this.companyName=companyName;
    }

}