package cn.smarthse.modules.health.entity.work.judge;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "occuptional_judge")
public class OccuptionalJudge implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 评定时间
     */
    @Column(name = "judge_date")
    private Date judgeDate;

    /**
     * 评定人
     */
    @Column(name = "judge_staff")
    private Long judgeStaff;
    
    /**
     * 评定人姓名（冗余）
     */
    @Column(name = "judge_staff_name")
    private String judgeStaffName;

    /**
     * 工作场所职业病危害严重程度:一般、严重
     */
    @Column(name = "workplace_judge_result")
    private String workplaceJudgeResult;

    /**
     * 接触职业病危害人数
     */
    @Column(name = "contact_hazards_staff_num")
    private Integer contactHazardsStaffNum;
    
    /**
     * 接触职业病危害人数说明
     */
    @Transient
    private String contactHazardsStaffNumInfo;

    /**
     * 接触职业病危害人数:大量、中量、少量
     */
    @Column(name = "contact_hazards_staff_grade")
    private String contactHazardsStaffGrade;

    /**
     * 职业健康管理现状:A,B,C
     */
    @Column(name = "occ_manage_status")
    private String occManageStatus;

    /**
     * 评定结果,企业职业病危害风险:高风险（红色）、中风险（黄色）、低风险（蓝色）
     * （不存数据库）
     */
//    @Column(name = "occ_hazard_risk")
    @Transient
    private String occHazardRisk;

    /**
     * 是否含有高毒物：-1，未判定，1、含有，0、不含
     */
    @Column(name = "has_high_poison")
    private Byte hasHighPoison;

    /**
     * 是否含有石棉纤维粉尘、含游离二氧化硅10%以上粉尘等职业病危害因素的：-1，未判定，1、含有，0、不含
     */
    @Column(name = "has_dust")
    private Byte hasDust;

    /**
     * 是否含有市县安全监管部门发布的严格监控的职业病危害因素：-1，未判定，1、含有，0、不含
     */
    @Column(name = "has_other_hazard_factors")
    private Byte hasOtherHazardFactors;

    /**
     * 管理制度检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "management_system_result")
    private Byte managementSystemResult;

    /**
     * 管理机构检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "management_agency_result")
    private Byte managementAgencyResult;

    /**
     * 管理人员检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "manager_result")
    private Byte managerResult;

    /**
     * 项目申报检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "project_declaration_result")
    private Byte projectDeclarationResult;

    /**
     * 三同时检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "third_time_result")
    private Byte thirdTimeResult;

    /**
     * 合同告知检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "contract_notification_result")
    private Byte contractNotificationResult;

    /**
     * 场所设置检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "work_place_set_result")
    private Byte workPlaceSetResult;

    /**
     * 合理布局检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "rational_layout_result")
    private Byte rationalLayoutResult;

    /**
     * 告知警示检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "warning_set_result")
    private Byte warningSetResult;

    /**
     * 危害检测检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "harm_test_result")
    private Byte harmTestResult;

    /**
     * 超标情况检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "exceeding_standard_result")
    private Byte exceedingStandardResult;

    /**
     * 现状评价检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "evaluation_result")
    private Byte evaluationResult;

    /**
     * 设施有效检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "device_result")
    private Byte deviceResult;

    /**
     * 用品配备检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "protective_equipment_allocation_result")
    private Byte protectiveEquipmentAllocationResult;

    /**
     * 使用管理检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "protective_equipment_use_result")
    private Byte protectiveEquipmentUseResult;

    /**
     * 负责人培训检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "director_train_result")
    private Byte directorTrainResult;

    /**
     * 劳动者培训检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "staff_train_result")
    private Byte staffTrainResult;

    /**
     * 上岗前和离岗时体检检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "pre_job_test_result")
    private Byte preJobTestResult;

    /**
     * 在岗期间体检检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "jobing_test_result")
    private Byte jobingTestResult;

    /**
     * 监护档案检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "wardship_file_result")
    private Byte wardshipFileResult;

    /**
     * 职业病检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "occ_diseass_result")
    private Byte occDiseassResult;

    /**
     * 行政处罚检查结果是否合格：-1，未判定，1、是，0、否
     */
    @Column(name = "super_inspection_result")
    private Byte superInspectionResult;

    /**
     * 业务数据状态，见枚举StatusEnum
     */
    private Byte status;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 一般项数量
     */
    @Transient
    private int generalItemNumber=15;
    
    /**
     * 一般项完成数量
     */
    @Transient
    private int generalItemNumberFinished;
    
    /**
     * 否决项数量
     */
    @Transient
    private int vetoItemNumber=7;
    
    /**
     * 否决项完成数量
     */
    @Transient
    private int vetoItemNumberFinished;
    
    /**
     * 评定默认值
     */
    @Transient
    private Byte defaultValue=-1; 
    
    @Transient
    private Byte checkYes=1;
    
    /**
     * 职业健康管理现状汇总
     * 包含22个评定项目，
     * 否决项全部合格、一般项有11项及以上合格的可判定为A级；
     * 否决项全部合格、一般项有6-10项合格的可判定为B级；
     * 否决项有不合格或否决项全部合格、一般项有5项及以下合格的可判定为C级。
     */
    @Transient
    private String occManageInfo;
    
    
    
    /**
     * 工作场所职业病危害严重程度。三种情况(hasHighPoison,hasDust,hasOtherHazardFactors)只要有一个及以上选择是，工作场所职业病危害严重程度就为严重，否则为一般。
     */
    @Transient
    private String workPlaceOccInfo;
    
    /**
     * 企业职业病危害风险
     */
    @Transient
    private String companyOccRisk;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取评定时间
     *
     * @return judge_date - 评定时间
     */
    public Date getJudgeDate() {
        return judgeDate;
    }

    /**
     * 设置评定时间
     *
     * @param judgeDate 评定时间
     */
    public void setJudgeDate(Date judgeDate) {
        this.judgeDate = judgeDate;
    }

    /**
     * 获取评定人
     *
     * @return judge_staff - 评定人
     */
    public Long getJudgeStaff() {
        return judgeStaff;
    }

    /**
     * 设置评定人
     *
     * @param judgeStaff 评定人
     */
    public void setJudgeStaff(Long judgeStaff) {
        this.judgeStaff = judgeStaff;
    }

    /**
     * 获取工作场所职业病危害严重程度:一般、严重
     *
     * @return workplace_judge_result - 工作场所职业病危害严重程度:一般、严重
     */
    public String getWorkplaceJudgeResult() {
        return workplaceJudgeResult;
    }

    /**
     * 设置工作场所职业病危害严重程度:一般、严重
     *
     * @param workplaceJudgeResult 工作场所职业病危害严重程度:一般、严重
     */
    public void setWorkplaceJudgeResult(String workplaceJudgeResult) {
        this.workplaceJudgeResult = workplaceJudgeResult == null ? null : workplaceJudgeResult.trim();
    }

    /**
     * 获取接触职业病危害人数
     *
     * @return contact_hazards_staff_num - 接触职业病危害人数
     */
    public Integer getContactHazardsStaffNum() {
        return contactHazardsStaffNum;
    }

    /**
     * 设置接触职业病危害人数
     *
     * @param contactHazardsStaffNum 接触职业病危害人数
     */
    public void setContactHazardsStaffNum(Integer contactHazardsStaffNum) {
        this.contactHazardsStaffNum = contactHazardsStaffNum;
    }

    /**
     * 获取接触职业病危害人数:大量、中量、少量
     *
     * @return contact_hazards_staff_grade - 接触职业病危害人数:大量、中量、少量
     */
    public String getContactHazardsStaffGrade() {
        return contactHazardsStaffGrade;
    }

    /**
     * 设置接触职业病危害人数:大量、中量、少量
     *
     * @param contactHazardsStaffGrade 接触职业病危害人数:大量、中量、少量
     */
    public void setContactHazardsStaffGrade(String contactHazardsStaffGrade) {
        this.contactHazardsStaffGrade = contactHazardsStaffGrade == null ? null : contactHazardsStaffGrade.trim();
    }

    /**
     * 获取职业健康管理现状:A,B,C
     *
     * @return occ_manage_status - 职业健康管理现状:A,B,C
     */
    public String getOccManageStatus() {
        return occManageStatus;
    }

    /**
     * 设置职业健康管理现状:A,B,C
     *
     * @param occManageStatus 职业健康管理现状:A,B,C
     */
    public void setOccManageStatus(String occManageStatus) {
        this.occManageStatus = occManageStatus == null ? null : occManageStatus.trim();
    }

    /**
     * 获取评定结果,企业职业病危害风险:高风险（红色）、中风险（黄色）、低风险（蓝色）
     *
     * @return occ_hazard_risk - 评定结果,企业职业病危害风险:高风险（红色）、中风险（黄色）、低风险（蓝色）
     */
    public String getOccHazardRisk() {
    	if(this.getCompanyOccRisk().equals("高风险")) {
    		return "<div class='riskB'><i class='riskD highRisk'></i> 高风险</div>";
    	}else if(this.getCompanyOccRisk().equals("中风险")) {
    		return "<div class='riskB'><i class='riskD centerRisk'></i> 中风险</div>";
    	}else {
    		return "<div class='riskB'><i class='riskD lowRisk'></i> 低风险</div>";
    	}
//        return occHazardRisk;
    }

    /**
     * 设置评定结果,企业职业病危害风险:高风险（红色）、中风险（黄色）、低风险（蓝色）
     *
     * @param occHazardRisk 评定结果,企业职业病危害风险:高风险（红色）、中风险（黄色）、低风险（蓝色）
     */
    public void setOccHazardRisk(String occHazardRisk) {
        this.occHazardRisk = occHazardRisk == null ? null : occHazardRisk.trim();
    }

    /**
     * 获取是否含有高毒物：-1，未判定，1、含有，0、不含
     *
     * @return has_high_poison - 是否含有高毒物：-1，未判定，1、含有，0、不含
     */
    public Byte getHasHighPoison() {
        return hasHighPoison;
    }

    /**
     * 设置是否含有高毒物：-1，未判定，1、含有，0、不含
     *
     * @param hasHighPoison 是否含有高毒物：-1，未判定，1、含有，0、不含
     */
    public void setHasHighPoison(Byte hasHighPoison) {
        this.hasHighPoison = hasHighPoison;
    }

    /**
     * 获取是否含有石棉纤维粉尘、含游离二氧化硅10%以上粉尘等职业病危害因素的：-1，未判定，1、含有，0、不含
     *
     * @return has_dust - 是否含有石棉纤维粉尘、含游离二氧化硅10%以上粉尘等职业病危害因素的：-1，未判定，1、含有，0、不含
     */
    public Byte getHasDust() {
        return hasDust;
    }

    /**
     * 设置是否含有石棉纤维粉尘、含游离二氧化硅10%以上粉尘等职业病危害因素的：-1，未判定，1、含有，0、不含
     *
     * @param hasDust 是否含有石棉纤维粉尘、含游离二氧化硅10%以上粉尘等职业病危害因素的：-1，未判定，1、含有，0、不含
     */
    public void setHasDust(Byte hasDust) {
        this.hasDust = hasDust;
    }

    /**
     * 获取是否含有市县安全监管部门发布的严格监控的职业病危害因素：-1，未判定，1、含有，0、不含
     *
     * @return has_other_hazard_factors - 是否含有市县安全监管部门发布的严格监控的职业病危害因素：-1，未判定，1、含有，0、不含
     */
    public Byte getHasOtherHazardFactors() {
        return hasOtherHazardFactors;
    }

    /**
     * 设置是否含有市县安全监管部门发布的严格监控的职业病危害因素：-1，未判定，1、含有，0、不含
     *
     * @param hasOtherHazardFactors 是否含有市县安全监管部门发布的严格监控的职业病危害因素：-1，未判定，1、含有，0、不含
     */
    public void setHasOtherHazardFactors(Byte hasOtherHazardFactors) {
        this.hasOtherHazardFactors = hasOtherHazardFactors;
    }

    /**
     * 获取管理制度检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return management_system_result - 管理制度检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getManagementSystemResult() {
        return managementSystemResult;
    }

    /**
     * 设置管理制度检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param managementSystemResult 管理制度检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setManagementSystemResult(Byte managementSystemResult) {
        this.managementSystemResult = managementSystemResult;
    }

    /**
     * 获取管理机构检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return management_agency_result - 管理机构检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getManagementAgencyResult() {
        return managementAgencyResult;
    }

    /**
     * 设置管理机构检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param managementAgencyResult 管理机构检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setManagementAgencyResult(Byte managementAgencyResult) {
        this.managementAgencyResult = managementAgencyResult;
    }

    /**
     * 获取管理人员检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return manager_result - 管理人员检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getManagerResult() {
        return managerResult;
    }

    /**
     * 设置管理人员检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param managerResult 管理人员检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setManagerResult(Byte managerResult) {
        this.managerResult = managerResult;
    }

    /**
     * 获取项目申报检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return project_declaration_result - 项目申报检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getProjectDeclarationResult() {
        return projectDeclarationResult;
    }

    /**
     * 设置项目申报检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param projectDeclarationResult 项目申报检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setProjectDeclarationResult(Byte projectDeclarationResult) {
        this.projectDeclarationResult = projectDeclarationResult;
    }

    /**
     * 获取三同时检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return third_time_result - 三同时检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getThirdTimeResult() {
        return thirdTimeResult;
    }

    /**
     * 设置三同时检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param thirdTimeResult 三同时检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setThirdTimeResult(Byte thirdTimeResult) {
        this.thirdTimeResult = thirdTimeResult;
    }

    /**
     * 获取合同告知检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return contract_notification_result - 合同告知检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getContractNotificationResult() {
        return contractNotificationResult;
    }

    /**
     * 设置合同告知检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param contractNotificationResult 合同告知检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setContractNotificationResult(Byte contractNotificationResult) {
        this.contractNotificationResult = contractNotificationResult;
    }

    /**
     * 获取场所设置检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return work_place_set_result - 场所设置检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getWorkPlaceSetResult() {
        return workPlaceSetResult;
    }

    /**
     * 设置场所设置检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param workPlaceSetResult 场所设置检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setWorkPlaceSetResult(Byte workPlaceSetResult) {
        this.workPlaceSetResult = workPlaceSetResult;
    }

    /**
     * 获取合理布局检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return rational_layout_result - 合理布局检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getRationalLayoutResult() {
        return rationalLayoutResult;
    }

    /**
     * 设置合理布局检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param rationalLayoutResult 合理布局检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setRationalLayoutResult(Byte rationalLayoutResult) {
        this.rationalLayoutResult = rationalLayoutResult;
    }

    /**
     * 获取告知警示检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return warning_set_result - 告知警示检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getWarningSetResult() {
        return warningSetResult;
    }

    /**
     * 设置告知警示检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param warningSetResult 告知警示检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setWarningSetResult(Byte warningSetResult) {
        this.warningSetResult = warningSetResult;
    }

    /**
     * 获取危害检测检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return harm_test_result - 危害检测检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getHarmTestResult() {
        return harmTestResult;
    }

    /**
     * 设置危害检测检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param harmTestResult 危害检测检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setHarmTestResult(Byte harmTestResult) {
        this.harmTestResult = harmTestResult;
    }

    /**
     * 获取超标情况检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return exceeding_standard_result - 超标情况检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getExceedingStandardResult() {
        return exceedingStandardResult;
    }

    /**
     * 设置超标情况检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param exceedingStandardResult 超标情况检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setExceedingStandardResult(Byte exceedingStandardResult) {
        this.exceedingStandardResult = exceedingStandardResult;
    }

    /**
     * 获取现状评价检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return evaluation_result - 现状评价检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getEvaluationResult() {
        return evaluationResult;
    }

    /**
     * 设置现状评价检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param evaluationResult 现状评价检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setEvaluationResult(Byte evaluationResult) {
        this.evaluationResult = evaluationResult;
    }

    /**
     * 获取设施有效检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return device_result - 设施有效检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getDeviceResult() {
        return deviceResult;
    }

    /**
     * 设置设施有效检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param deviceResult 设施有效检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setDeviceResult(Byte deviceResult) {
        this.deviceResult = deviceResult;
    }

    /**
     * 获取用品配备检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return protective_equipment_allocation_result - 用品配备检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getProtectiveEquipmentAllocationResult() {
        return protectiveEquipmentAllocationResult;
    }

    /**
     * 设置用品配备检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param protectiveEquipmentAllocationResult 用品配备检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setProtectiveEquipmentAllocationResult(Byte protectiveEquipmentAllocationResult) {
        this.protectiveEquipmentAllocationResult = protectiveEquipmentAllocationResult;
    }

    /**
     * 获取使用管理检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return protective_equipment_use_result - 使用管理检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getProtectiveEquipmentUseResult() {
        return protectiveEquipmentUseResult;
    }

    /**
     * 设置使用管理检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param protectiveEquipmentUseResult 使用管理检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setProtectiveEquipmentUseResult(Byte protectiveEquipmentUseResult) {
        this.protectiveEquipmentUseResult = protectiveEquipmentUseResult;
    }

    /**
     * 获取负责人培训检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return director_train_result - 负责人培训检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getDirectorTrainResult() {
        return directorTrainResult;
    }

    /**
     * 设置负责人培训检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param directorTrainResult 负责人培训检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setDirectorTrainResult(Byte directorTrainResult) {
        this.directorTrainResult = directorTrainResult;
    }

    /**
     * 获取劳动者培训检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return staff_train_result - 劳动者培训检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getStaffTrainResult() {
        return staffTrainResult;
    }

    /**
     * 设置劳动者培训检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param staffTrainResult 劳动者培训检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setStaffTrainResult(Byte staffTrainResult) {
        this.staffTrainResult = staffTrainResult;
    }

    /**
     * 获取上岗前和离岗时体检检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return pre_job_test_result - 上岗前和离岗时体检检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getPreJobTestResult() {
        return preJobTestResult;
    }

    /**
     * 设置上岗前和离岗时体检检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param preJobTestResult 上岗前和离岗时体检检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setPreJobTestResult(Byte preJobTestResult) {
        this.preJobTestResult = preJobTestResult;
    }

    /**
     * 获取在岗期间体检检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return jobing_test_result - 在岗期间体检检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getJobingTestResult() {
        return jobingTestResult;
    }

    /**
     * 设置在岗期间体检检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param jobingTestResult 在岗期间体检检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setJobingTestResult(Byte jobingTestResult) {
        this.jobingTestResult = jobingTestResult;
    }

    /**
     * 获取监护档案检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return wardship_file_result - 监护档案检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getWardshipFileResult() {
        return wardshipFileResult;
    }

    /**
     * 设置监护档案检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param wardshipFileResult 监护档案检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setWardshipFileResult(Byte wardshipFileResult) {
        this.wardshipFileResult = wardshipFileResult;
    }

    /**
     * 获取职业病检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return occ_diseass_result - 职业病检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getOccDiseassResult() {
        return occDiseassResult;
    }

    /**
     * 设置职业病检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param occDiseassResult 职业病检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setOccDiseassResult(Byte occDiseassResult) {
        this.occDiseassResult = occDiseassResult;
    }

    /**
     * 获取行政处罚检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @return super_inspection_result - 行政处罚检查结果是否合格：-1，未判定，1、是，0、否
     */
    public Byte getSuperInspectionResult() {
        return superInspectionResult;
    }

    /**
     * 设置行政处罚检查结果是否合格：-1，未判定，1、是，0、否
     *
     * @param superInspectionResult 行政处罚检查结果是否合格：-1，未判定，1、是，0、否
     */
    public void setSuperInspectionResult(Byte superInspectionResult) {
        this.superInspectionResult = superInspectionResult;
    }

    /**
     * 获取业务数据状态，见枚举StatusEnum
     *
     * @return status - 业务数据状态，见枚举StatusEnum
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置业务数据状态，见枚举StatusEnum
     *
     * @param status 业务数据状态，见枚举StatusEnum
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getJudgeStaffName() {
		return judgeStaffName;
	}

	public void setJudgeStaffName(String judgeStaffName) {
		this.judgeStaffName = judgeStaffName;
	}

	public int getGeneralItemNumber() {
		return generalItemNumber;
	}
	
	/**
	 * 一般项合格的数量。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月9日-下午4:29:29
	 * @return
	 */
	private int getGeneralItemQualifiedNum() {
		return this.getGeneralItemNum(checkYes,true);
	}
	
	/**
	 * 否决项合格的数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月9日-下午4:41:54
	 * @return
	 */
	private int getVetoItemQualifiedNum() {
		return this.getVetoItemNum(checkYes, true);
	}
	
	private int getGeneralItemNum(Byte checkValue,boolean isCheckYes) {

		int i=0;
		if(!checkValue.equals(this.getManagementSystemResult())) {
			i++;
		}
		if(!checkValue.equals(this.getManagerResult())) {
			i++;
		}
		if(!checkValue.equals(this.getEvaluationResult())) {
			i++;
		}
		if(!checkValue.equals(this.getExceedingStandardResult())) {
			i++;
		}
		if(!checkValue.equals(this.getWorkPlaceSetResult())) {
			i++;
		}
		if(!checkValue.equals(this.getWarningSetResult())) {
			i++;
		}
		if(!checkValue.equals(this.getThirdTimeResult())) {
			i++;
		}
		if(!checkValue.equals(this.getContractNotificationResult())) {
			i++;
		}
		if(!checkValue.equals(this.getDeviceResult())) {
			i++;
		}
		if(!checkValue.equals(this.getProtectiveEquipmentAllocationResult())) {
			i++;
		}
		if(!checkValue.equals(this.getProtectiveEquipmentUseResult())) {
			i++;
		}
		if(!checkValue.equals(this.getDirectorTrainResult())) {
			i++;
		}
		if(!checkValue.equals(this.getStaffTrainResult())) {
			i++;
		}
		if(!checkValue.equals(this.getPreJobTestResult())) {
			i++;
		}
		if(!checkValue.equals(this.getWardshipFileResult())) {
			i++;
		}
		if(isCheckYes) {
			i=generalItemNumber-i;
		}
		
		return i;
	
	}

	public int getGeneralItemNumberFinished() {
		return this.getGeneralItemNum(defaultValue,false);
	}

	public int getVetoItemNumber() {
		return vetoItemNumber;
	}

	public int getVetoItemNum(Byte checkValue,boolean isCheckYes) {
		int i =0;
		if(!checkValue.equals(this.getManagementAgencyResult())) {
			i++;
		}
		if(!checkValue.equals(this.getHarmTestResult())) {
			i++;
		}
		if(!checkValue.equals(this.getRationalLayoutResult())) {
			i++;
		}
		if(!checkValue.equals(this.getProjectDeclarationResult())) {
			i++;
		}
		if(!checkValue.equals(this.getJobingTestResult())) {
			i++;
		}
		if(!checkValue.equals(this.getOccDiseassResult())) {
			i++;
		}
		if(!checkValue.equals(this.getSuperInspectionResult())) {
			i++;
		}
		if(isCheckYes) {
			i=vetoItemNumber-i;
		}
		return i;
	
	}
	public int getVetoItemNumberFinished() {
		return this.getVetoItemNum(defaultValue,false);
	}

	public String getWorkPlaceOccInfo() {
		int i=0;
		if(checkYes.equals(this.hasHighPoison)) {
			i++;
		}
		if(checkYes.equals(this.hasDust)) {
			i++;
		}
		if(checkYes.equals(this.hasOtherHazardFactors)) {
			i++;
		}
		
		return i>0?"严重":"一般";
	}

	public String getContactHazardsStaffNumInfo() {
		if(this.contactHazardsStaffNum==null) {
			return "";
		}
		if(this.contactHazardsStaffNum<=9) {
			return "少量";
		}
		
		if(this.contactHazardsStaffNum>=10 && this.contactHazardsStaffNum<=49) {
			return "中量";
		}
		
		if(this.contactHazardsStaffNum>=9) {
			return "大量";
		}
		
		return "";
	}

	public String getOccManageInfo() {
		if(this.getVetoItemQualifiedNum() == this.vetoItemNumber) {
			//否决项全部合格
			if(this.getGeneralItemQualifiedNum()>=11) {
				//一般项全部合格
				return "A";
			}else if(this.getGeneralItemQualifiedNum()>=6 && this.getGeneralItemQualifiedNum()<=10) {
				//一般项，6-10项合格
				return "B";
			}else {
				//一般项，5项以下合格
				return "C";
			}
			
		}else {
			//否决项有不合格项
			return "C";
		}
	}

	public String getCompanyOccRisk() {
		if("严重".equals(this.getWorkPlaceOccInfo())) {
			if("大量".equals(this.getContactHazardsStaffNumInfo()) || "中量".equals(this.getContactHazardsStaffNumInfo())) {
				if("A".equals(this.getOccManageInfo())) {
					return "中风险";
				}else {
					return "高风险";
				}
			}else {
				//少量
				if("A".equals(this.getOccManageInfo())) {
					return "低风险";
				}else if("B".equals(this.getOccManageInfo())) {
					return "中风险";
				}else {
					return "高风险";
				}
			}
		}else {
			if("大量".equals(this.getContactHazardsStaffNumInfo())) {
				if("A".equals(this.getOccManageInfo())) {
					return "低风险";
				}else if("B".equals(this.getOccManageInfo())) {
					return "中风险";
				}else {
					return "高风险";
				}
			}else {
				if("A".equals(this.getOccManageInfo())) {
					return "低风险";
				}else if("B".equals(this.getOccManageInfo())) {
					return "低风险";
				}else {
					return "中风险";
				}
			}
		}
	}
	
}