package cn.smarthse.modules.health.entity.work.informmanager;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.*;

@Table(name = "occupational_disease_contraindication")
public class OccupationalDiseaseContraindication implements Serializable {
	
	
	/**
	 * 危害因素名字
	 */
	@Transient
	private String harmName;
	
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 危害因素代码
     */
    @Column(name = "param_code")
    private String paramCode;

    /**
     * 合同告知模板id
     */
    @Column(name = "template_id")
    private Long templateId;

    /**
     * 岗位ID
     */
    @Column(name = "work_id")
    private Long workId;

    /**
     * 危害因素id
     */
    @Column(name = "harm_Id")
    private Long harmId;

    /**
     * 疾病描述
     */
    private String disease;

    /**
     * 禁忌症描述
     */
    private String contraindication;

    /**
     * 防护措施
     */
    private String precautions;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;


    /**
     * 可能导致的职业病危害(原始数据来自riskInfo表)
     */
    @Transient
    private List<RiskInfo> riskInfoList;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取危害因素代码
     *
     * @return param_code - 危害因素代码
     */
    public String getParamCode() {
        return paramCode;
    }

    /**
     * 设置危害因素代码
     *
     * @param paramCode 危害因素代码
     */
    public void setParamCode(String paramCode) {
        this.paramCode = paramCode == null ? null : paramCode.trim();
    }

    /**
     * 获取合同告知模板id
     *
     * @return template_id - 合同告知模板id
     */
    public Long getTemplateId() {
        return templateId;
    }

    /**
     * 设置合同告知模板id
     *
     * @param templateId 合同告知模板id
     */
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    /**
     * 获取岗位ID
     *
     * @return work_id - 岗位ID
     */
    public Long getWorkId() {
        return workId;
    }

    /**
     * 设置岗位ID
     *
     * @param workId 岗位ID
     */
    public void setWorkId(Long workId) {
        this.workId = workId;
    }

    /**
     * 获取危害因素id
     *
     * @return harm_Id - 危害因素id
     */
    public Long getHarmId() {
        return harmId;
    }

    /**
     * 设置危害因素id
     *
     * @param harmId 危害因素id
     */
    public void setHarmId(Long harmId) {
        this.harmId = harmId;
    }

    /**
     * 获取疾病描述
     *
     * @return disease - 疾病描述
     */
    public String getDisease() {
        return disease;
    }

    /**
     * 设置疾病描述
     *
     * @param disease 疾病描述
     */
    public void setDisease(String disease) {
        this.disease = disease == null ? null : disease.trim();
    }

    /**
     * 获取禁忌症描述
     *
     * @return contraindication - 禁忌症描述
     */
    public String getContraindication() {
        return contraindication;
    }

    /**
     * 设置禁忌症描述
     *
     * @param contraindication 禁忌症描述
     */
    public void setContraindication(String contraindication) {
        this.contraindication = contraindication == null ? null : contraindication.trim();
    }

    /**
     * 获取防护措施
     *
     * @return precautions - 防护措施
     */
    public String getPrecautions() {
        return precautions;
    }

    /**
     * 设置防护措施
     *
     * @param precautions 防护措施
     */
    public void setPrecautions(String precautions) {
        this.precautions = precautions == null ? null : precautions.trim();
    }

    /**
     * 获取备注
     *
     * @return remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public String getHarmName() {
		return harmName;
	}

	public void setHarmName(String harmName) {
		this.harmName = harmName;
	}

    public List<RiskInfo> getRiskInfoList() {
        return riskInfoList;
    }

    public void setRiskInfoList(List<RiskInfo> riskInfoList) {
        this.riskInfoList = riskInfoList;
    }
}