package cn.smarthse.modules.health.entity.work.informmanager;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

@Table(name = "no_inform_staff")
public class NoInformStaff implements Serializable {
	
	

	/**
	 * 用于更新和添加最新（当前）的岗位变更信息（人员岗位关系表Id）
	 */
	@Column(name = "staff_work_role_id")
	private  Long  staffWorkRoleId;
	
	
	@Transient
	private String orgIdsStr;
	
	
	/**
	 * 多个组织部门id(用英文逗号隔开，用于界面搜索)
	 */
	@Transient
	private List<Long>  orgIds;
	
	
	/**
	 * 岗位名称
	 */
	@Transient
	private String workName;
	
	/**
	 *危害因素名称(用逗号隔开)
	 */
	@Transient
	private String harmNames;
	
	/**
	 * 部门名称
	 */
	@Transient
	private String orgName;
	
	/**
	 * 姓名
	 */
	@Transient
	private String realName;
	
	
	/**
	 * 组织ID
	 */
	@Transient
	private Long orgId;
	
	/**
	 * 工号
	 */
	@Transient
	private String workNo;
	
	/**
	 * 性别
	 */
	@Transient
	private Byte gender;
	
	/**
	 * 岗位变动情况 1在岗 5转岗  6复岗(就是休假超过60天复岗) 
	 */
	@Column(name = "chang_work_status")
	private  Byte changWorkStatus;
	
	/**
	 * 搜索关键字
	 */
	@Transient
	private String searchKey;
	
    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 人员信息Staff_info的ID
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 岗位信息ID
     */
    @Column(name = "work_info_id")
    private Long workInfoId;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 更新时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 更新人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 数据有效性
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取主键ID
     *
     * @return id - 主键ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键ID
     *
     * @param id 主键ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取人员信息Staff_info的ID
     *
     * @return staff_id - 人员信息Staff_info的ID
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置人员信息Staff_info的ID
     *
     * @param staffId 人员信息Staff_info的ID
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取岗位信息ID
     *
     * @return work_info_id - 岗位信息ID
     */
    public Long getWorkInfoId() {
        return workInfoId;
    }

    /**
     * 设置岗位信息ID
     *
     * @param workInfoId 岗位信息ID
     */
    public void setWorkInfoId(Long workInfoId) {
        this.workInfoId = workInfoId;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取更新时间
     *
     * @return update_date - 更新时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置更新时间
     *
     * @param updateDate 更新时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取更新人
     *
     * @return update_by - 更新人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置更新人
     *
     * @param updateBy 更新人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取数据有效性
     *
     * @return is_valid - 数据有效性
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置数据有效性
     *
     * @param isValid 数据有效性
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getSearchKey() {
		return searchKey;
	}

	public void setSearchKey(String searchKey) {
		this.searchKey = searchKey;
	}

	public Byte getChangWorkStatus() {
		return changWorkStatus;
	}

	public void setChangWorkStatus(Byte changWorkStatus) {
		this.changWorkStatus = changWorkStatus;
	}


	public String getWorkNo() {
		return workNo;
	}

	public void setWorkNo(String workNo) {
		this.workNo = workNo;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getRealName() {
		return realName;
	}

	public void setRealName(String realName) {
		this.realName = realName;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getHarmNames() {
		return harmNames;
	}

	public void setHarmNames(String harmNames) {
		this.harmNames = harmNames;
	}

	public String getWorkName() {
		return workName;
	}

	public void setWorkName(String workName) {
		this.workName = workName;
	}

	public List<Long> getOrgIds() {
		return orgIds;
	}

	public void setOrgIds(List<Long> orgIds) {
		this.orgIds = orgIds;
	}

	public String getOrgIdsStr() {
		return orgIdsStr;
	}

	public void setOrgIdsStr(String orgIdsStr) {
		this.orgIdsStr = orgIdsStr;
	}

	public Long getStaffWorkRoleId() {
		return staffWorkRoleId;
	}

	public void setStaffWorkRoleId(Long staffWorkRoleId) {
		this.staffWorkRoleId = staffWorkRoleId;
	}

	public Byte getGender() {
		return gender;
	}

	public void setGender(Byte gender) {
		this.gender = gender;
	}

}