package cn.smarthse.modules.health.entity.work.informmanager;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWork;
import cn.smarthse.modules.health.enums.staff.ContractInformReasonEnum;

@Table(name = "contract_inform")
public class ContractInform implements Serializable {
	
	

	/**
	 * 岗位工种关系表ID（staff_work_role表ID）
	 */
	@Column(name = "staff_work_role_id")
	private Long staffWorkRoleId;
	
	/**
	 * 搜索关键字
	 */
	@Transient
	private String searchKey;
	
	@Transient
	private Integer informYear;
	
	/**
	 *告知原由
	 */
	@Transient
	private String informReasonStr;
	
	/**
	 * 岗位名称
	 */
	@Transient
	private String workName;
	
	/**
	 * 姓名 
	 */
	@Transient
	private String realName;
	
	/**
	 * 人员工号
	 */
	@Transient
	private String workNo;
	
	/**
	 * 岗位所接触的危害因素
	 */
	@Transient
	private List<HarmfactorWork>   harmfactorWorks; 
	/**
	 * 人员信息
	 */
	@Transient
	private StaffInfo staffInfo;
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 告知人员ID
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 纸质告知单文件ID
     */
    @Column(name = "paper_file_ID")
    private Long paperFileId;

    /**
     * 告知原由
     */
    @Column(name = "inform_reason")
    private String informReason;

    /**
     * 预从事的岗位ID
     */
    @Column(name = "inform_work_id")
    private Long informWorkId;

    /**
     * 告知模板ID
     */
    @Column(name = "inform_Temp_ID")
    private Long informTempId;

    /**
     * 告知状态(0-未告知,1-已告知)
     */
    @Column(name = "inform_state")
    private Long informState;

    /**
     * 告知时间
     */
    @Column(name = "inform_Date")
    private Date informDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 忽略字段用于（未告知的人员）这个人员的岗位是否忽略告知
     */
    @Column(name = "is_ignore")
    private Boolean isIgnore;
    
    @Column(name = "org_id")
    private Long orgId;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取告知人员ID
     *
     * @return staff_id - 告知人员ID
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置告知人员ID
     *
     * @param staffId 告知人员ID
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取纸质告知单文件ID
     *
     * @return paper_file_ID - 纸质告知单文件ID
     */
    public Long getPaperFileId() {
        return paperFileId;
    }

    /**
     * 设置纸质告知单文件ID
     *
     * @param paperFileId 纸质告知单文件ID
     */
    public void setPaperFileId(Long paperFileId) {
        this.paperFileId = paperFileId;
    }

    /**
     * 获取告知原由
     *
     * @return inform_reason - 告知原由
     */
    public String getInformReason() {
        return informReason;
    }

    /**
     * 设置告知原由
     *
     * @param informReason 告知原由
     */
    public void setInformReason(String informReason) {
        this.informReason = informReason == null ? null : informReason.trim();
    }

    /**
     * 获取预从事的岗位ID
     *
     * @return inform_work_id - 预从事的岗位ID
     */
    public Long getInformWorkId() {
        return informWorkId;
    }

    /**
     * 设置预从事的岗位ID
     *
     * @param informWorkId 预从事的岗位ID
     */
    public void setInformWorkId(Long informWorkId) {
        this.informWorkId = informWorkId;
    }

    /**
     * 获取告知模板ID
     *
     * @return inform_Temp_ID - 告知模板ID
     */
    public Long getInformTempId() {
        return informTempId;
    }

    /**
     * 设置告知模板ID
     *
     * @param informTempId 告知模板ID
     */
    public void setInformTempId(Long informTempId) {
        this.informTempId = informTempId;
    }

    /**
     * 获取告知状态(0-未告知,1-已告知)
     *
     * @return inform_state - 告知状态(0-未告知,1-已告知)
     */
    public Long getInformState() {
        return informState;
    }

    /**
     * 设置告知状态(0-未告知,1-已告知)
     *
     * @param informState 告知状态(0-未告知,1-已告知)
     */
    public void setInformState(Long informState) {
        this.informState = informState;
    }

    /**
     * 获取告知时间
     *
     * @return inform_Date - 告知时间
     */
    public Date getInformDate() {
        return informDate;
    }

    /**
     * 设置告知时间
     *
     * @param informDate 告知时间
     */
    public void setInformDate(Date informDate) {
        this.informDate = informDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public StaffInfo getStaffInfo() {
		return staffInfo;
	}

	public void setStaffInfo(StaffInfo staffInfo) {
		this.staffInfo = staffInfo;
	}

	public List<HarmfactorWork> getHarmfactorWorks() {
		return harmfactorWorks;
	}

	public void setHarmfactorWorks(List<HarmfactorWork> harmfactorWorks) {
		this.harmfactorWorks = harmfactorWorks;
	}

	public String getWorkNo() {
		return workNo;
	}

	public void setWorkNo(String workNo) {
		this.workNo = workNo;
	}

	public String getRealName() {
		return realName;
	}

	public void setRealName(String realName) {
		this.realName = realName;
	}

	public String getWorkName() {
		return workName;
	}

	public void setWorkName(String workName) {
		this.workName = workName;
	}

	public String getInformReasonStr() {
		if(ContractInformReasonEnum.GOTOWORK.getValue().toString().equals(informReason)){
			informReasonStr=ContractInformReasonEnum.GOTOWORK.getName();
		}else if(ContractInformReasonEnum.AGAINWORK.getValue().toString().equals(informReason)){
			informReasonStr=ContractInformReasonEnum.AGAINWORK.getName();
			
		}else if(ContractInformReasonEnum.CHANGEWORKCONTENT.getValue().toString().equals(informReason)){
			informReasonStr=ContractInformReasonEnum.CHANGEWORKCONTENT.getName();
			
		}else if(ContractInformReasonEnum.TRANSFERWORK.getValue().toString().equals(informReason)){
			informReasonStr=ContractInformReasonEnum.TRANSFERWORK.getName();
		}
		
		return informReasonStr;
	}

	public void setInformReasonStr(String informReasonStr) {
		this.informReasonStr = informReasonStr;
	}

	public String getSearchKey() {
		return searchKey;
	}

	public void setSearchKey(String searchKey) {
		this.searchKey = searchKey;
	}

	public Long getStaffWorkRoleId() {
		return staffWorkRoleId;
	}

	public void setStaffWorkRoleId(Long staffWorkRoleId) {
		this.staffWorkRoleId = staffWorkRoleId;
	}

	public Boolean getIsIgnore() {
		return isIgnore;
	}

	public void setIsIgnore(Boolean isIgnore) {
		this.isIgnore = isIgnore;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getInformYear() {
		return informYear;
	}

	public void setInformYear(Integer informYear) {
		this.informYear = informYear;
	}
}