package cn.smarthse.modules.health.entity.work.hccheckplan;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "work_area_sample_relation")
public class WorkAreaSampleRelation implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 关联工作表id
     */
    @Column(name = "underway_id")
    private Long underwayId;

    /**
     * 采样点/采样对象
     */
    @Column(name = "sample_name")
    private String sampleName;

    /**
     * 1:存草稿状态 2：完成状态
     */
    @Column(name = "save_status")
    private Byte saveStatus;

    /**
     * 导入批次uuid标识
     */
    @Column(name = "batch_flag")
    private String batchFlag;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取关联工作表id
     *
     * @return underway_id - 关联工作表id
     */
    public Long getUnderwayId() {
        return underwayId;
    }

    /**
     * 设置关联工作表id
     *
     * @param underwayId 关联工作表id
     */
    public void setUnderwayId(Long underwayId) {
        this.underwayId = underwayId;
    }

    /**
     * 获取采样点/采样对象
     *
     * @return sample_name - 采样点/采样对象
     */
    public String getSampleName() {
        return sampleName;
    }

    /**
     * 设置采样点/采样对象
     *
     * @param sampleName 采样点/采样对象
     */
    public void setSampleName(String sampleName) {
        this.sampleName = sampleName == null ? null : sampleName.trim();
    }

    /**
     * 获取1:存草稿状态 2：完成状态
     *
     * @return save_status - 1:存草稿状态 2：完成状态
     */
    public Byte getSaveStatus() {
        return saveStatus;
    }

    /**
     * 设置1:存草稿状态 2：完成状态
     *
     * @param saveStatus 1:存草稿状态 2：完成状态
     */
    public void setSaveStatus(Byte saveStatus) {
        this.saveStatus = saveStatus;
    }

    /**
     * 获取导入批次uuid标识
     *
     * @return batch_flag - 导入批次uuid标识
     */
    public String getBatchFlag() {
        return batchFlag;
    }

    /**
     * 设置导入批次uuid标识
     *
     * @param batchFlag 导入批次uuid标识
     */
    public void setBatchFlag(String batchFlag) {
        this.batchFlag = batchFlag == null ? null : batchFlag.trim();
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}