package cn.smarthse.modules.health.entity.work.hccheckplan;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "no_exist_harm")
public class NoExistHarm implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;
   
    @Column(name = "hc_id")
    private Long  hcId;
    
    /**
     * 在系统中不存在的危害因素
     */
    @Column(name = "harm_name")
    private String harmName;

    /**
     * 来自hc_check_result_collect_data对应的行标识
     */
    @Column(name = "row_flag")
    private String rowFlag;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    private static final long serialVersionUID = 1L;

    /**
     * 获取主键
     *
     * @return id - 主键
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键
     *
     * @param id 主键
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取在系统中不存在的危害因素
     *
     * @return harm_name - 在系统中不存在的危害因素
     */
    public String getHarmName() {
        return harmName;
    }

    /**
     * 设置在系统中不存在的危害因素
     *
     * @param harmName 在系统中不存在的危害因素
     */
    public void setHarmName(String harmName) {
        this.harmName = harmName == null ? null : harmName.trim();
    }

    /**
     * 获取来自hc_check_result_collect_data对应的行标识
     *
     * @return row_flag - 来自hc_check_result_collect_data对应的行标识
     */
    public String getRowFlag() {
        return rowFlag;
    }

    /**
     * 设置来自hc_check_result_collect_data对应的行标识
     *
     * @param rowFlag 来自hc_check_result_collect_data对应的行标识
     */
    public void setRowFlag(String rowFlag) {
        this.rowFlag = rowFlag == null ? null : rowFlag.trim();
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

	public Long getHcId() {
		return hcId;
	}

	public void setHcId(Long hcId) {
		this.hcId = hcId;
	}
}