package cn.smarthse.modules.health.entity.work.hccheckplan;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckResultTypeEnum;

@Table(name = "hc_collect_ultravioletlight_v")
public class HcCollectUltravioletlightV implements Serializable {
	/**
	 * 查询结束时间
	 */
	@Transient
	private Date searchEndTime;
	@Transient
	private String harmId;
	
	/**
	 * 岗位Id
	 */
	@Transient
	private Long workId;
	/**
	 * 危害来源即采样点
	 * 
	 */
	@Transient
	private String harmSources;
	
	@Transient
	private String classifyName;
	
	@Transient
	private HcCheckPlan hcCheckPlan;
	
	@Transient
	private String resultName;
	
	@Transient
	private String resultName1;
	@Transient
	private String resultName2;
	@Transient
	private String resultName3;
	
	/**
	 * 操作列
	 */
	@Transient
	private String operationStr;
	
	
    /**
     * ID
     */
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病危害因素检测id
     */
    @Column(name = "hc_id")
    private Long hcId;

    /**
     * 行号标识
     */
    @Column(name = "row_flag")
    private String rowFlag;

    /**
     * hc_check_result_collect表的id
     */
    @Column(name = "result_collect_id")
    private Long resultCollectId;

    /**
     * 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    @Column(name = "is_selected")
    private Boolean isSelected;

    /**
     * 结果汇总类别（1到17见具体的枚举类）
     */
    @Column(name = "collect_type")
    private Byte collectType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 采样点/对象
     */
    @Column(name = "report_name")
    private String reportName;

    /**
     * 紫外光谱分类 0中波紫外线 1 短波紫外线2电焊弧光
     */
    private String classify;

    /**
     * 接触时间(h)
     */
    private String time;

    /**
     * 辐照度(μW/cm<sup>2</sup>)
     */
    private String irradiance;

    /**
     * 照射量(mJ/cm<sup>2</sup>)
     */
    private String exposure;

    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result;
    
    
    /**
     * 辐照度(μW/cm<sup>2</sup>)
     */
    private String irradiance1;
    
    /**
     * 照射量(mJ/cm<sup>2</sup>)
     */
    private String exposure1;
    
    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result1;
    
    /**
     * 辐照度(μW/cm<sup>2</sup>)
     */
    private String irradiance2;
    
    /**
     * 照射量(mJ/cm<sup>2</sup>)
     */
    private String exposure2;
    
    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result2;
    
    /**
     * 辐照度(μW/cm<sup>2</sup>)
     */
    private String irradiance3;
    
    /**
     * 照射量(mJ/cm<sup>2</sup>)
     */
    private String exposure3;
    
    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result3;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病危害因素检测id
     *
     * @return hc_id - 职业病危害因素检测id
     */
    public Long getHcId() {
        return hcId;
    }

    /**
     * 设置职业病危害因素检测id
     *
     * @param hcId 职业病危害因素检测id
     */
    public void setHcId(Long hcId) {
        this.hcId = hcId;
    }

    /**
     * 获取行号标识
     *
     * @return row_flag - 行号标识
     */
    public String getRowFlag() {
        return rowFlag;
    }

    /**
     * 设置行号标识
     *
     * @param rowFlag 行号标识
     */
    public void setRowFlag(String rowFlag) {
        this.rowFlag = rowFlag == null ? null : rowFlag.trim();
    }

    /**
     * 获取hc_check_result_collect表的id
     *
     * @return result_collect_id - hc_check_result_collect表的id
     */
    public Long getResultCollectId() {
        return resultCollectId;
    }

    /**
     * 设置hc_check_result_collect表的id
     *
     * @param resultCollectId hc_check_result_collect表的id
     */
    public void setResultCollectId(Long resultCollectId) {
        this.resultCollectId = resultCollectId;
    }

    /**
     * 获取界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @return is_selected - 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public Boolean getIsSelected() {
        return isSelected;
    }

    /**
     * 设置界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @param isSelected 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    /**
     * 获取结果汇总类别（1到17见具体的枚举类）
     *
     * @return collect_type - 结果汇总类别（1到17见具体的枚举类）
     */
    public Byte getCollectType() {
        return collectType;
    }

    /**
     * 设置结果汇总类别（1到17见具体的枚举类）
     *
     * @param collectType 结果汇总类别（1到17见具体的枚举类）
     */
    public void setCollectType(Byte collectType) {
        this.collectType = collectType;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * @return report_name
     */
    public String getReportName() {
        return reportName;
    }

    /**
     * @param reportName
     */
    public void setReportName(String reportName) {
        this.reportName = reportName == null ? null : reportName.trim();
    }

    /**
     * @return classify
     */
    public String getClassify() {
        return classify;
    }

    /**
     * @param classify
     */
    public void setClassify(String classify) {
        this.classify = classify == null ? null : classify.trim();
    }

    /**
     * @return time
     */
    public String getTime() {
        return time;
    }

    /**
     * @param time
     */
    public void setTime(String time) {
        this.time = time == null ? null : time.trim();
    }

    /**
     * @return irradiance
     */
    public String getIrradiance() {
        return irradiance;
    }

    /**
     * @param irradiance
     */
    public void setIrradiance(String irradiance) {
        this.irradiance = irradiance == null ? null : irradiance.trim();
    }

    /**
     * @return exposure
     */
    public String getExposure() {
        return exposure;
    }

    /**
     * @param exposure
     */
    public void setExposure(String exposure) {
        this.exposure = exposure == null ? null : exposure.trim();
    }

    /**
     * @return result
     */
    public String getResult() {
        return result;
    }

    /**
     * @param result
     */
    public void setResult(String result) {
        this.result = result == null ? null : result.trim();
    }
    
    public String getResultName() {
		if(StringUtils.isNotEmpty(result)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}
    	}
		
		return resultName;
	}

	public void setResultName(String resultName) {
		this.resultName = resultName;
	}
	public String getOperationStr() {
		return "<a href=\"javascript:cloneCollectChemical('"+id+"');\" class='ui-pg-div ml5' title='克隆' ><i class='ui-icon icon-ui-icon icon-copy green'></i></a>"
				+ "<a href=\"javascript:editCollectChemical('"+id+"');\" class='ui-pg-div ml5' title='编辑'><i class='ui-icon icon-pencil bigger-110 green'></i></a>"
				+ "<a href=\"javascript:deleteCollectChemicalByDataId('"+id+"');\" class='ui-pg-div ml5' title='删除'><i class='ui-icon icon-trash red'></i></a>";
	}

	public void setOperationStr(String operationStr) {
		this.operationStr = operationStr;
	}

	public HcCheckPlan getHcCheckPlan() {
		return hcCheckPlan;
	}

	public void setHcCheckPlan(HcCheckPlan hcCheckPlan) {
		this.hcCheckPlan = hcCheckPlan;
	}

	public String getClassifyName() {
		classifyName="";
		if("0".equals(classify)){
			classifyName="中波紫外线";
    	}else if("1".equals(classify)){
    		classifyName="短波紫外线";
    	}else if("2".equals(classify)){
    		classifyName="电焊弧光";
    	}else{
    		classifyName="";
    	}
		return classifyName;
	}

	public void setClassifyName(String classifyName) {
		this.classifyName = classifyName;
	}

	public String getHarmSources() {
		return harmSources;
	}

	public void setHarmSources(String harmSources) {
		this.harmSources = harmSources;
	}

	public Long getWorkId() {
		return workId;
	}

	public void setWorkId(Long workId) {
		this.workId = workId;
	}

	public String getHarmId() {
		return harmId;
	}

	public void setHarmId(String harmId) {
		this.harmId = harmId;
	}
	
	public String getResultName1() {
		if(StringUtils.isNotEmpty(result1)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result1)){
    			resultName1=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result1)){
    			resultName1=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result1)){
    			resultName1=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}
    	}
		return resultName1;
	}

	public void setResultName1(String resultName1) {
		this.resultName1 = resultName1;
	}

	public String getResultName2() {
		if(StringUtils.isNotEmpty(result2)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result2)){
    			resultName2=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result2)){
    			resultName2=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result2)){
    			resultName2=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}
    	}
		return resultName2;
	}

	public void setResultName2(String resultName2) {
		this.resultName2 = resultName2;
	}

	public String getResultName3() {
		if(StringUtils.isNotEmpty(result3)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result3)){
    			resultName3=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result3)){
    			resultName3=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result3)){
    			resultName3=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}
    	}
		return resultName3;
	}

	public void setResultName3(String resultName3) {
		this.resultName3 = resultName3;
	}

	public String getIrradiance1() {
		return irradiance1;
	}

	public void setIrradiance1(String irradiance1) {
		this.irradiance1 = irradiance1;
	}

	public String getExposure1() {
		return exposure1;
	}

	public void setExposure1(String exposure1) {
		this.exposure1 = exposure1;
	}

	public String getResult1() {
		return result1;
	}

	public void setResult1(String result1) {
		this.result1 = result1;
	}

	public String getIrradiance2() {
		return irradiance2;
	}

	public void setIrradiance2(String irradiance2) {
		this.irradiance2 = irradiance2;
	}

	public String getExposure2() {
		return exposure2;
	}

	public void setExposure2(String exposure2) {
		this.exposure2 = exposure2;
	}

	public String getResult2() {
		return result2;
	}

	public void setResult2(String result2) {
		this.result2 = result2;
	}

	public String getIrradiance3() {
		return irradiance3;
	}

	public void setIrradiance3(String irradiance3) {
		this.irradiance3 = irradiance3;
	}

	public String getExposure3() {
		return exposure3;
	}

	public void setExposure3(String exposure3) {
		this.exposure3 = exposure3;
	}

	public String getResult3() {
		return result3;
	}

	public void setResult3(String result3) {
		this.result3 = result3;
	}

	public Date getSearchEndTime() {
		return searchEndTime;
	}

	public void setSearchEndTime(Date searchEndTime) {
		this.searchEndTime = searchEndTime;
	}
	
}