package cn.smarthse.modules.health.entity.work.hccheckplan;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckNoiseTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckResultTypeEnum;

@Table(name = "hc_collect_noise_v")
public class HcCollectNoiseV implements Serializable {
	/**
	 * 查询结束时间
	 */
	@Transient
	private Date searchEndTime;
	@Transient
	private String harmId;
	
	/**
	 * 岗位Id
	 */
	@Transient
	private Long workId;
	
	/**
	 * 危害来源即采样点
	 * 
	 */
	@Transient
	private String harmSources;
	
	@Transient
	private HcCheckPlan hcCheckPlan;
	
	/**
	 * 判定结果名称
	 */
	@Transient
	private String resultName;
	
	
	
	/**
	 * 噪声类型名称
	 */
	@Transient
	private String noiseTypeName;
	
	
    /**
     * ID
     */
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病危害因素检测id
     */
    @Column(name = "hc_id")
    private Long hcId;

    /**
     * 行号标识
     */
    @Column(name = "row_flag")
    private String rowFlag;

    /**
     * hc_check_result_collect表的id
     */
    @Column(name = "result_collect_id")
    private Long resultCollectId;

    /**
     * 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    @Column(name = "is_selected")
    private Boolean isSelected;

    /**
     * 结果汇总类别（1到17见具体的枚举类）
     */
    @Column(name = "collect_type")
    private Byte collectType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 采样点/对象
     */
    @Column(name = "report_name")
    private String reportName;

    /**
     * 0 稳态噪声 1 非稳态噪声 2脉冲噪声
     */
    @Column(name = "noise_type")
    private String noiseType;
    
    
    /**
     * 1 个人 2 场所
     */
    private String noisetype1;

    /**
     * 检测数值[dB(A)]
     */
    @Column(name = "check_value00")
    private String checkValue00;
    /**
     * 检测数值[dB(A)]
     */
    @Column(name = "check_value0")
    private String checkValue0;
    /**
     * 检测数值[dB(A)]
     */
    @Column(name = "check_value")
    private String checkValue;
    
    @Transient
	private String checkValueVal;

    /**
     * 最低值[dB(A)]
     */
    @Column(name = "min_value")
    private String minValue;

    /**
     * 最高值[dB(A)]
     */
    @Column(name = "max_value")
    private String maxValue;

    /**
     * 8/40h等效声级[dB(A)]
     */
    @Column(name = "equal_level")
    private String equalLevel;

    /**
     * 工作日接触脉冲次数(次)
     */
    private String times;

    /**
     * 声压级峰值[dB(A)]
     */
    @Column(name = "max_noise")
    private String maxNoise;

    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病危害因素检测id
     *
     * @return hc_id - 职业病危害因素检测id
     */
    public Long getHcId() {
        return hcId;
    }

    /**
     * 设置职业病危害因素检测id
     *
     * @param hcId 职业病危害因素检测id
     */
    public void setHcId(Long hcId) {
        this.hcId = hcId;
    }

    /**
     * 获取行号标识
     *
     * @return row_flag - 行号标识
     */
    public String getRowFlag() {
        return rowFlag;
    }

    /**
     * 设置行号标识
     *
     * @param rowFlag 行号标识
     */
    public void setRowFlag(String rowFlag) {
        this.rowFlag = rowFlag == null ? null : rowFlag.trim();
    }

    /**
     * 获取hc_check_result_collect表的id
     *
     * @return result_collect_id - hc_check_result_collect表的id
     */
    public Long getResultCollectId() {
        return resultCollectId;
    }

    /**
     * 设置hc_check_result_collect表的id
     *
     * @param resultCollectId hc_check_result_collect表的id
     */
    public void setResultCollectId(Long resultCollectId) {
        this.resultCollectId = resultCollectId;
    }

    /**
     * 获取界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @return is_selected - 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public Boolean getIsSelected() {
        return isSelected;
    }

    /**
     * 设置界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @param isSelected 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    /**
     * 获取结果汇总类别（1到17见具体的枚举类）
     *
     * @return collect_type - 结果汇总类别（1到17见具体的枚举类）
     */
    public Byte getCollectType() {
        return collectType;
    }

    /**
     * 设置结果汇总类别（1到17见具体的枚举类）
     *
     * @param collectType 结果汇总类别（1到17见具体的枚举类）
     */
    public void setCollectType(Byte collectType) {
        this.collectType = collectType;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * @return report_name
     */
    public String getReportName() {
        return reportName;
    }

    /**
     * @param reportName
     */
    public void setReportName(String reportName) {
        this.reportName = reportName == null ? null : reportName.trim();
    }

    /**
     * @return noise_type
     */
    public String getNoiseType() {
        return noiseType;
    }

    /**
     * @param noiseType
     */
    public void setNoiseType(String noiseType) {
        this.noiseType = noiseType == null ? null : noiseType.trim();
    }

    /**
     * @return check_value
     */
    public String getCheckValue() {
        return checkValue;
    }

    /**
     * @param checkValue
     */
    public void setCheckValue(String checkValue) {
        this.checkValue = checkValue == null ? null : checkValue.trim();
    }

    /**
     * @return min_value
     */
    public String getMinValue() {
        return minValue;
    }

    /**
     * @param minValue
     */
    public void setMinValue(String minValue) {
        this.minValue = minValue == null ? null : minValue.trim();
    }

    /**
     * @return max_value
     */
    public String getMaxValue() {
        return maxValue;
    }

    /**
     * @param maxValue
     */
    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue == null ? null : maxValue.trim();
    }

    /**
     * @return equal_level
     */
    public String getEqualLevel() {
        return equalLevel;
    }

    /**
     * @param equalLevel
     */
    public void setEqualLevel(String equalLevel) {
        this.equalLevel = equalLevel == null ? null : equalLevel.trim();
    }

    /**
     * @return times
     */
    public String getTimes() {
        return times;
    }

    /**
     * @param times
     */
    public void setTimes(String times) {
        this.times = times == null ? null : times.trim();
    }

    /**
     * @return max_noise
     */
    public String getMaxNoise() {
        return maxNoise;
    }

    /**
     * @param maxNoise
     */
    public void setMaxNoise(String maxNoise) {
        this.maxNoise = maxNoise == null ? null : maxNoise.trim();
    }

    /**
     * @return result
     */
    public String getResult() {
        return result;
    }

    /**
     * @param result
     */
    public void setResult(String result) {
        this.result = result == null ? null : result.trim();
    }

	public String getNoiseTypeName() {
		if("1".equals(noisetype1)) {
			noiseTypeName="个体";
		}else {
			if(StringUtils.isNotEmpty(noiseType)){
	    		if(HcCheckNoiseTypeEnum.FIXEDNOISE.getCode().toString().equals(noiseType)){
	    			noiseTypeName=HcCheckNoiseTypeEnum.FIXEDNOISE.getName();
	    		}else if(HcCheckNoiseTypeEnum.NOTFIXEDNOISE.getCode().toString().equals(noiseType)){
	    			noiseTypeName=HcCheckNoiseTypeEnum.NOTFIXEDNOISE.getName();
	    		}else if(HcCheckNoiseTypeEnum.PULSENOISE.getCode().toString().equals(noiseType)){
	    			noiseTypeName=HcCheckNoiseTypeEnum.PULSENOISE.getName();
	    		}
		}
		
    	}
		return noiseTypeName;
	}

	public void setNoiseTypeName(String noiseTypeName) {
		this.noiseTypeName = noiseTypeName;
	}

	public String getResultName() {
		if(StringUtils.isNotEmpty(result)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}
    	}
		
		return resultName;
	}

	public void setResultName(String resultName) {
		this.resultName = resultName;
	}

	public HcCheckPlan getHcCheckPlan() {
		return hcCheckPlan;
	}

	public void setHcCheckPlan(HcCheckPlan hcCheckPlan) {
		this.hcCheckPlan = hcCheckPlan;
	}

	public String getHarmSources() {
		return harmSources;
	}

	public void setHarmSources(String harmSources) {
		this.harmSources = harmSources;
	}

	public Long getWorkId() {
		return workId;
	}

	public void setWorkId(Long workId) {
		this.workId = workId;
	}

	public String getHarmId() {
		return harmId;
	}

	public void setHarmId(String harmId) {
		this.harmId = harmId;
	}
	public String getNoisetype1() {
		return noisetype1;
	}

	public void setNoisetype1(String noisetype1) {
		this.noisetype1 = noisetype1;
	}

	public Date getSearchEndTime() {
		return searchEndTime;
	}

	public void setSearchEndTime(Date searchEndTime) {
		this.searchEndTime = searchEndTime;
	}

	public String getCheckValue00() {
		return checkValue00;
	}

	public void setCheckValue00(String checkValue00) {
		this.checkValue00 = checkValue00;
	}

	public String getCheckValue0() {
		return checkValue0;
	}

	public void setCheckValue0(String checkValue0) {
		this.checkValue0 = checkValue0;
	}

	public String getCheckValueVal() {

		checkValueVal = "";

		if (StringUtils.isNotEmpty(checkValue00) && StringUtils.isNumber(checkValue00)) {

			if (Integer.valueOf(NumberUtil.toInt(checkValue00.trim())) == 1) {
				checkValueVal += "＜";
			} else if (Integer.valueOf(NumberUtil.toInt(checkValue00.trim())) == 2) {
				checkValueVal += "≤";
			}
		}
		if (StringUtils.isNotEmpty(checkValue0)) {
			checkValueVal += checkValue0;
		}
		if (StringUtils.isNotEmpty(checkValueVal) && StringUtils.isNotEmpty(checkValue)) {
			checkValueVal += "~";
		}
		if (StringUtils.isNotEmpty(checkValue)) {
			checkValueVal += checkValue;
		}

		return checkValueVal;
	}

	public void setCheckValueVal(String checkValueVal) {
		this.checkValueVal = checkValueVal;
	}
	
}