package cn.smarthse.modules.health.entity.work.hccheckplan;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckResultTypeEnum;

@Table(name = "hc_collect_microclimate_v")
public class HcCollectMicroclimateV implements Serializable {
	
	/**
	 * 查询结束时间
	 */
	@Transient
	private Date searchEndTime;
	/**
	 * 岗位Id
	 */
	@Transient
	private Long workId;
	/**
	 * 危害来源即采样点
	 * 
	 */
	@Transient
	private String harmSources;
	
	@Transient
	private HcCheckPlan hcCheckPlan;
	@Transient
	private String resultName1;
	
	@Transient
	private String resultName2;
	
	@Transient
	private String resultName3;
	
	@Transient
	private String resultName;
	
	@Transient
	private String checkResult;
	
	@Transient
	private String paramName;
	
	/**
	 * 操作列
	 */
	@Transient
	private String operationStr;
	
	
    /**
     * ID
     */
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病危害因素检测id
     */
    @Column(name = "hc_id")
    private Long hcId;

    /**
     * 行号标识
     */
    @Column(name = "row_flag")
    private String rowFlag;

    /**
     * hc_check_result_collect表的id
     */
    @Column(name = "result_collect_id")
    private Long resultCollectId;

    /**
     * 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    @Column(name = "is_selected")
    private Boolean isSelected;

    /**
     * 结果汇总类别（1到17见具体的枚举类）
     */
    @Column(name = "collect_type")
    private Byte collectType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 采样点/对象
     */
    @Column(name = "report_name")
    private String reportName;

    /**
     * 温度(℃)
     */
    @Column(name = "check_result1")
    private String checkResult1;

    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result1;

    /**
     * 风速(m/s)
     */
    @Column(name = "check_result2")
    private String checkResult2;

    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result2;

    /**
     * 相对湿度(%)
     */
    @Column(name = "check_result3")
    private String checkResult3;

    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result3;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病危害因素检测id
     *
     * @return hc_id - 职业病危害因素检测id
     */
    public Long getHcId() {
        return hcId;
    }

    /**
     * 设置职业病危害因素检测id
     *
     * @param hcId 职业病危害因素检测id
     */
    public void setHcId(Long hcId) {
        this.hcId = hcId;
    }

    /**
     * 获取行号标识
     *
     * @return row_flag - 行号标识
     */
    public String getRowFlag() {
        return rowFlag;
    }

    /**
     * 设置行号标识
     *
     * @param rowFlag 行号标识
     */
    public void setRowFlag(String rowFlag) {
        this.rowFlag = rowFlag == null ? null : rowFlag.trim();
    }

    /**
     * 获取hc_check_result_collect表的id
     *
     * @return result_collect_id - hc_check_result_collect表的id
     */
    public Long getResultCollectId() {
        return resultCollectId;
    }

    /**
     * 设置hc_check_result_collect表的id
     *
     * @param resultCollectId hc_check_result_collect表的id
     */
    public void setResultCollectId(Long resultCollectId) {
        this.resultCollectId = resultCollectId;
    }

    /**
     * 获取界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @return is_selected - 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public Boolean getIsSelected() {
        return isSelected;
    }

    /**
     * 设置界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @param isSelected 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    /**
     * 获取结果汇总类别（1到17见具体的枚举类）
     *
     * @return collect_type - 结果汇总类别（1到17见具体的枚举类）
     */
    public Byte getCollectType() {
        return collectType;
    }

    /**
     * 设置结果汇总类别（1到17见具体的枚举类）
     *
     * @param collectType 结果汇总类别（1到17见具体的枚举类）
     */
    public void setCollectType(Byte collectType) {
        this.collectType = collectType;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * @return report_name
     */
    public String getReportName() {
        return reportName;
    }

    /**
     * @param reportName
     */
    public void setReportName(String reportName) {
        this.reportName = reportName == null ? null : reportName.trim();
    }

    /**
     * @return check_result1
     */
    public String getCheckResult1() {
    	//注释掉by hesy,在档案4里面，需要用此数据，且要转换成BigDecimal类型，如果返回&nbsp;&nbsp，则要报错。
//    	if(StringUtils.isEmpty(checkResult1)){
//    		checkResult1="&nbsp;&nbsp;";
//    	}
        return checkResult1;
    }

    /**
     * @param checkResult1
     */
    public void setCheckResult1(String checkResult1) {
        this.checkResult1 = checkResult1 == null ? null : checkResult1.trim();
    }

    /**
     * @return result1
     */
    public String getResult1() {
        return result1;
    }

    /**
     * @param result1
     */
    public void setResult1(String result1) {
        this.result1 = result1 == null ? null : result1.trim();
    }

    /**
     * @return check_result2
     */
    public String getCheckResult2() {
    	//注释掉by hesy,在档案4里面，需要用此数据，且要转换成BigDecimal类型，如果返回&nbsp;&nbsp，则要报错。
//    	if(StringUtils.isEmpty(checkResult2)){
//    		checkResult2="&nbsp;&nbsp;";
//    	}
        return checkResult2;
    }

    /**
     * @param checkResult2
     */
    public void setCheckResult2(String checkResult2) {
        this.checkResult2 = checkResult2 == null ? null : checkResult2.trim();
    }

    /**
     * @return result2
     */
    public String getResult2() {
        return result2;
    }

    /**
     * @param result2
     */
    public void setResult2(String result2) {
        this.result2 = result2 == null ? null : result2.trim();
    }

    /**
     * @return check_result3
     */
    public String getCheckResult3() {
    	//注释掉by hesy,在档案4里面，需要用此数据，且要转换成BigDecimal类型，如果返回&nbsp;&nbsp，则要报错。
//    	if(StringUtils.isEmpty(checkResult3)){
//    		checkResult3="&nbsp;&nbsp;";
//    	}
        return checkResult3;
    }

    /**
     * @param checkResult3
     */
    public void setCheckResult3(String checkResult3) {
        this.checkResult3 = checkResult3 == null ? null : checkResult3.trim();
    }

    /**
     * @return result3
     */
    public String getResult3() {
        return result3;
    }

    /**
     * @param result3
     */
    public void setResult3(String result3) {
        this.result3 = result3 == null ? null : result3.trim();
    }
    
    public String getResultName1() {
		if(StringUtils.isNotEmpty(result1)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result1)){
    			resultName1=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result1)){
    			resultName1=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result1)){
    			resultName1=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}else{
    			resultName1="&nbsp;&nbsp;";
    		}
    	}else{
    		resultName1="&nbsp;&nbsp;";
    	}
		
		return resultName1;
	}

	public void setResultName2(String resultName2) {
		this.resultName2 = resultName2;
	}
	
	public String getResultName2() {
		if(StringUtils.isNotEmpty(result2)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result2)){
    			resultName2=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result2)){
    			resultName2=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result2)){
    			resultName2=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}else{
    			resultName2="&nbsp;&nbsp;";
    		}
    	}else{
    		resultName2="&nbsp;&nbsp;";
    	}
		
		return resultName2;
	}
	
	

	public void setResultName1(String resultName1) {
		this.resultName1 = resultName1;
	}
	
	public void setResultName3(String resultName3) {
		this.resultName3 = resultName3;
	}
	
	public String getResultName3() {
		if(StringUtils.isNotEmpty(result3)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result3)){
    			resultName3=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result3)){
    			resultName3=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result3)){
    			resultName3=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}else{
    			resultName3="&nbsp;&nbsp;";
    		}
    	}else{
    		resultName3="&nbsp;&nbsp;";
    	}
		
		return resultName3;
	}
	
	
	
	public String getOperationStr() {
		return "<a href=\"javascript:cloneCollectChemical('"+id+"');\" class='ui-pg-div ml5' title='克隆' ><i class='ui-icon icon-ui-icon icon-copy green'></i></a>"
				+ "<a href=\"javascript:editCollectChemical('"+id+"');\" class='ui-pg-div ml5' title='编辑'><i class='ui-icon icon-pencil bigger-110 green'></i></a>"
				+ "<a href=\"javascript:deleteCollectChemicalByDataId('"+id+"');\" class='ui-pg-div ml5' title='删除'><i class='ui-icon icon-trash red'></i></a>";
	}

	public void setOperationStr(String operationStr) {
		this.operationStr = operationStr;
	}

	public String getResultName() {
		resultName=""
				+ ""+getResultName1()+"<hr />"
				+ ""+getResultName2()+"<hr />"
				+ ""+getResultName3()+"";
		return resultName;
	}

	public void setResultName(String resultName) {
		this.resultName = resultName;
	}

	public String getCheckResult() {
		checkResult=""
				+ ""+(StringUtils.isNotEmpty(checkResult1)?getCheckResult1():"-")+"<hr />"
				+ ""+(StringUtils.isNotEmpty(checkResult2)?getCheckResult2():"-")+"<hr />"
				+ ""+(StringUtils.isNotEmpty(checkResult3)?getCheckResult3():"-")+"";
		
		
		return checkResult;
	}

	public void setCheckresult(String checkResult) {
		this.checkResult = checkResult;
	}

	public String getParamName() {
		paramName=""
				+ "温度(℃)<hr />"
				+ "风速(m/s)<hr />"
				+ "相对湿度(%)";
		return paramName;
	}

	public void setParamName(String paramName) {
		this.paramName = paramName;
	}

	public HcCheckPlan getHcCheckPlan() {
		return hcCheckPlan;
	}

	public void setHcCheckPlan(HcCheckPlan hcCheckPlan) {
		this.hcCheckPlan = hcCheckPlan;
	}

	public String getHarmSources() {
		return harmSources;
	}

	public void setHarmSources(String harmSources) {
		this.harmSources = harmSources;
	}

	public Long getWorkId() {
		return workId;
	}

	public void setWorkId(Long workId) {
		this.workId = workId;
	}

	public Date getSearchEndTime() {
		return searchEndTime;
	}

	public void setSearchEndTime(Date searchEndTime) {
		this.searchEndTime = searchEndTime;
	}

	public void setCheckResult(String checkResult) {
		this.checkResult = checkResult;
	}
	
}