package cn.smarthse.modules.health.entity.work.hccheckplan;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckContactSiteEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckResultTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckSpectralRangeEnum;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "hc_collect_laser_radiation_v")
public class HcCollectLaserRadiationV implements Serializable {
	/**
	 * 查询结束时间
	 */
	@Transient
	private Date searchEndTime;
	@Transient
	private String harmId;
	/**
	 * 岗位Id
	 */
	@Transient
	private Long workId;
	
	/**
	 * 危害来源即采样点
	 * 
	 */
	@Transient
	private String harmSources;
	
	@Transient
	private HcCheckPlan hcCheckPlan;
	/**
	 * 辐照度(W/cm2)
	 */
	@Transient
	private String irradiance;
	
	/**
	 * 照射量(J/cm2) 
	 */
	@Transient
	private String exposure;
	
	
	/**
	 * 照射时间(s)
	 */
	@Transient
	private String irradiationTime;
	
	/**
	 * 光谱范围
	 */
	@Transient
	private String rangeName;
	
	/**
	 * 接触部位
	 */
	@Transient
	private String locationName;
	
	/**
	 * 判定结果名称
	 */
	@Transient
	private String resultName;
	
    /**
     * ID
     */
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病危害因素检测id
     */
    @Column(name = "hc_id")
    private Long hcId;

    /**
     * 行号标识
     */
    @Column(name = "row_flag")
    private String rowFlag;

    /**
     * hc_check_result_collect表的id
     */
    @Column(name = "result_collect_id")
    private Long resultCollectId;

    /**
     * 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    @Column(name = "is_selected")
    private Boolean isSelected;

    /**
     * 结果汇总类别（1到17见具体的枚举类）
     */
    @Column(name = "collect_type")
    private Byte collectType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 采样点/对象
     */
    @Column(name = "report_name")
    private String reportName;

    /**
     * 接触部位 0 眼1皮肤
     */
    private String location;

    /**
     * 接触时间(h)
     */
    private String time;

    /**
     * 波长(n/m)
     */
    @Column(name = "wave_length")
    private String waveLength;

    /**
     * 照射时间(s)
     */
    @Column(name = "irradiation_time1")
    private String irradiationTime1;

    /**
     * 照射时间(s) 10的次方
     */
    @Column(name = "irradiation_time2")
    private String irradiationTime2;

    /**
     * 照射时间(s)
     */
    @Column(name = "irradiation_time3")
    private String irradiationTime3;

    /**
     * 照射时间(s) 10的次方
     */
    @Column(name = "irradiation_time4")
    private String irradiationTime4;

    /**
     * 照射量(J/cm<sup>2</sup>)
     */
    private String exposure1;

    /**
     * 照射量(J/cm<sup>2</sup>) 10的次方
     */
    private String exposure2;

    /**
     * 照射量(J/cm<sup>2</sup>)
     */
    private String exposure3;

    /**
     * 照射量(J/cm<sup>2</sup>) 10的次方
     */
    private String exposure4;

    /**
     * 辐照度(W/cm<sup>2</sup>)
     */
    private String irradiance1;

    /**
     * 辐照度(W/cm<sup>2</sup>) 10的次方
     * 
     */
    private String irradiance2;

    /**
     * 辐照度(W/cm<sup>2</sup>)
     */
    private String irradiance3;

    /**
     * 辐照度(W/cm<sup>2</sup>) 10的次方
     */
    private String irradiance4;

    /**
     * 波长(n/m)
     */
    @Column(name = "range_str")
    private String rangeStr;

    private String result;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病危害因素检测id
     *
     * @return hc_id - 职业病危害因素检测id
     */
    public Long getHcId() {
        return hcId;
    }

    /**
     * 设置职业病危害因素检测id
     *
     * @param hcId 职业病危害因素检测id
     */
    public void setHcId(Long hcId) {
        this.hcId = hcId;
    }

    /**
     * 获取行号标识
     *
     * @return row_flag - 行号标识
     */
    public String getRowFlag() {
        return rowFlag;
    }

    /**
     * 设置行号标识
     *
     * @param rowFlag 行号标识
     */
    public void setRowFlag(String rowFlag) {
        this.rowFlag = rowFlag == null ? null : rowFlag.trim();
    }

    /**
     * 获取hc_check_result_collect表的id
     *
     * @return result_collect_id - hc_check_result_collect表的id
     */
    public Long getResultCollectId() {
        return resultCollectId;
    }

    /**
     * 设置hc_check_result_collect表的id
     *
     * @param resultCollectId hc_check_result_collect表的id
     */
    public void setResultCollectId(Long resultCollectId) {
        this.resultCollectId = resultCollectId;
    }

    /**
     * 获取界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @return is_selected - 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public Boolean getIsSelected() {
        return isSelected;
    }

    /**
     * 设置界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @param isSelected 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    /**
     * 获取结果汇总类别（1到17见具体的枚举类）
     *
     * @return collect_type - 结果汇总类别（1到17见具体的枚举类）
     */
    public Byte getCollectType() {
        return collectType;
    }

    /**
     * 设置结果汇总类别（1到17见具体的枚举类）
     *
     * @param collectType 结果汇总类别（1到17见具体的枚举类）
     */
    public void setCollectType(Byte collectType) {
        this.collectType = collectType;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * @return report_name
     */
    public String getReportName() {
        return reportName;
    }

    /**
     * @param reportName
     */
    public void setReportName(String reportName) {
        this.reportName = reportName == null ? null : reportName.trim();
    }

    /**
     * @return location
     */
    public String getLocation() {
        return location;
    }

    /**
     * @param location
     */
    public void setLocation(String location) {
        this.location = location == null ? null : location.trim();
    }

    /**
     * @return time
     */
    public String getTime() {
        return time;
    }

    /**
     * @param time
     */
    public void setTime(String time) {
        this.time = time == null ? null : time.trim();
    }

    /**
     * @return wave_length
     */
    public String getWaveLength() {
        return waveLength;
    }

    /**
     * @param waveLength
     */
    public void setWaveLength(String waveLength) {
        this.waveLength = waveLength == null ? null : waveLength.trim();
    }

    /**
     * @return irradiation_time1
     */
    public String getIrradiationTime1() {
        return irradiationTime1;
    }

    /**
     * @param irradiationTime1
     */
    public void setIrradiationTime1(String irradiationTime1) {
        this.irradiationTime1 = irradiationTime1 == null ? null : irradiationTime1.trim();
    }

    /**
     * @return irradiation_time2
     */
    public String getIrradiationTime2() {
        return irradiationTime2;
    }

    /**
     * @param irradiationTime2
     */
    public void setIrradiationTime2(String irradiationTime2) {
        this.irradiationTime2 = irradiationTime2 == null ? null : irradiationTime2.trim();
    }

    /**
     * @return irradiation_time3
     */
    public String getIrradiationTime3() {
        return irradiationTime3;
    }

    /**
     * @param irradiationTime3
     */
    public void setIrradiationTime3(String irradiationTime3) {
        this.irradiationTime3 = irradiationTime3 == null ? null : irradiationTime3.trim();
    }

    /**
     * @return irradiation_time4
     */
    public String getIrradiationTime4() {
        return irradiationTime4;
    }

    /**
     * @param irradiationTime4
     */
    public void setIrradiationTime4(String irradiationTime4) {
        this.irradiationTime4 = irradiationTime4 == null ? null : irradiationTime4.trim();
    }

    /**
     * @return exposure1
     */
    public String getExposure1() {
        return exposure1;
    }

    /**
     * @param exposure1
     */
    public void setExposure1(String exposure1) {
        this.exposure1 = exposure1 == null ? null : exposure1.trim();
    }

    /**
     * @return exposure2
     */
    public String getExposure2() {
        return exposure2;
    }

    /**
     * @param exposure2
     */
    public void setExposure2(String exposure2) {
        this.exposure2 = exposure2 == null ? null : exposure2.trim();
    }

    /**
     * @return exposure3
     */
    public String getExposure3() {
        return exposure3;
    }

    /**
     * @param exposure3
     */
    public void setExposure3(String exposure3) {
        this.exposure3 = exposure3 == null ? null : exposure3.trim();
    }

    /**
     * @return exposure4
     */
    public String getExposure4() {
        return exposure4;
    }

    /**
     * @param exposure4
     */
    public void setExposure4(String exposure4) {
        this.exposure4 = exposure4 == null ? null : exposure4.trim();
    }

    /**
     * @return irradiance1
     */
    public String getIrradiance1() {
        return irradiance1;
    }

    /**
     * @param irradiance1
     */
    public void setIrradiance1(String irradiance1) {
        this.irradiance1 = irradiance1 == null ? null : irradiance1.trim();
    }

    /**
     * @return irradiance2
     */
    public String getIrradiance2() {
        return irradiance2;
    }

    /**
     * @param irradiance2
     */
    public void setIrradiance2(String irradiance2) {
        this.irradiance2 = irradiance2 == null ? null : irradiance2.trim();
    }

    /**
     * @return irradiance3
     */
    public String getIrradiance3() {
        return irradiance3;
    }

    /**
     * @param irradiance3
     */
    public void setIrradiance3(String irradiance3) {
        this.irradiance3 = irradiance3 == null ? null : irradiance3.trim();
    }

    /**
     * @return irradiance4
     */
    public String getIrradiance4() {
        return irradiance4;
    }

    /**
     * @param irradiance4
     */
    public void setIrradiance4(String irradiance4) {
        this.irradiance4 = irradiance4 == null ? null : irradiance4.trim();
    }

    /**
     * @return range_str
     */
    public String getRangeStr() {
        return rangeStr;
    }

    /**
     * @param rangeStr
     */
    public void setRangeStr(String rangeStr) {
        this.rangeStr = rangeStr == null ? null : rangeStr.trim();
    }

    /**
     * @return result
     */
    public String getResult() {
        return result;
    }

    /**
     * @param result
     */
    public void setResult(String result) {
        this.result = result == null ? null : result.trim();
    } 	
 	public String getResultName() {
		if(StringUtils.isNotEmpty(result)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}
    	}
		
		return resultName;
	}

	public void setResultName(String resultName) {
		this.resultName = resultName;
	}

	public String getLocationName() {
		if(HcCheckContactSiteEnum.EYE.getCode().toString().equals(location)){
			locationName=HcCheckContactSiteEnum.EYE.getName();
		}else if(HcCheckContactSiteEnum.SKIN.getCode().toString().equals(location)){
			locationName=HcCheckContactSiteEnum.SKIN.getName();
		}
		return locationName;
	}

	public void setLocationName(String locationName) {
		this.locationName = locationName;
	}

	public String getRangeName() {
		if(HcCheckSpectralRangeEnum.FARINFRARED.getCode().toString().equals(rangeStr)){
			rangeName=HcCheckSpectralRangeEnum.FARINFRARED.getName();
		}else if(HcCheckSpectralRangeEnum.INFRARED.getCode().toString().equals(rangeStr)){
			rangeName=HcCheckSpectralRangeEnum.INFRARED.getName();
		}else if(HcCheckSpectralRangeEnum.ULTRAVIOLETRADIATION.getCode().toString().equals(rangeStr)){
			rangeName=HcCheckSpectralRangeEnum.ULTRAVIOLETRADIATION.getName();
		}else if(HcCheckSpectralRangeEnum.VISIBLELIGHT.getCode().toString().equals(rangeStr)){
			rangeName=HcCheckSpectralRangeEnum.VISIBLELIGHT.getName();
		}
		return rangeName;
	}

	public void setRangeName(String rangeName) {
		this.rangeName = rangeName;
	}

	public String getIrradiationTime() {
		irradiationTime="";
		if(StringUtils.isNotEmpty(irradiationTime1)){
			irradiationTime+=irradiationTime1;
		}
		if(StringUtils.isNotEmpty(irradiationTime2)){
			irradiationTime+="×10<sup>"+irradiationTime2+"</sup>";
		}
		if(StringUtils.isNotEmpty(irradiationTime)&&(StringUtils.isNotEmpty(irradiationTime3)||StringUtils.isNotEmpty(irradiationTime4))){
			irradiationTime+="~";
		}
		if(StringUtils.isNotEmpty(irradiationTime3)){
			irradiationTime+=irradiationTime3;
		}
		if(StringUtils.isNotEmpty(irradiationTime4)){
			irradiationTime+="×10<sup>"+irradiationTime4+"</sup>";
		}
		
//		irradiationTime=irradiationTime1+"×10"+irradiationTime2+"~"+irradiationTime3+"×10"+irradiationTime4;
		return irradiationTime;
	}

	public void setIrradiationTime(String irradiationTime) {
		this.irradiationTime = irradiationTime;
	}
	
	/**
	 * 获取检测结果，档案特有
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年10月25日-下午3:24:00
	 * @return
	 */
	public String getExposureForArchive(){
		exposure="";
		if(StringUtils.isNotEmpty(exposure1)){
			exposure+=exposure1;
		}
		if(StringUtils.isNotEmpty(exposure2)){
			exposure+="×10"+StringUtils.replaceToSquareChar(exposure2);
		}
		if(StringUtils.isNotEmpty(exposure)&&(StringUtils.isNotEmpty(exposure3)||StringUtils.isNotEmpty(exposure4))){
			exposure+="~";
		}
		if(StringUtils.isNotEmpty(exposure3)){
			exposure+=exposure3;
		}
		if(StringUtils.isNotEmpty(exposure4)){
			exposure+="×10"+StringUtils.replaceToSquareChar(exposure4);
		}
		return exposure;
	
	}

	public String getExposure() {
		exposure="";
		if(StringUtils.isNotEmpty(exposure1)){
			exposure+=exposure1;
		}
		if(StringUtils.isNotEmpty(exposure2)){
			exposure+="×10<sup>"+exposure2+"</sup>";
		}
		if(StringUtils.isNotEmpty(exposure)&&(StringUtils.isNotEmpty(exposure3)||StringUtils.isNotEmpty(exposure4))){
			exposure+="~";
		}
		if(StringUtils.isNotEmpty(exposure3)){
			exposure+=exposure3;
		}
		if(StringUtils.isNotEmpty(exposure4)){
			exposure+="×10<sup>"+exposure4+"</sup>";
		}
		return exposure;
	}

	public void setExposure(String exposure) {
		this.exposure = exposure;
	}
	
	/**
	 * 档案特有
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年10月25日-下午3:31:37
	 * @return
	 */
	public String getIrradianceForArchive() {
		irradiance="";
		if(StringUtils.isNotEmpty(irradiance1)){
			irradiance+=irradiance1;
		}
		if(StringUtils.isNotEmpty(irradiance2)){
			irradiance+="×10"+StringUtils.replaceToSquareChar(irradiance2);
		}
		if(StringUtils.isNotEmpty(irradiance)&&(StringUtils.isNotEmpty(irradiance3)||StringUtils.isNotEmpty(irradiance4))){
			irradiance+="~";
		}
		if(StringUtils.isNotEmpty(irradiance3)){
			irradiance+=irradiance3;
		}
		if(StringUtils.isNotEmpty(irradiance4)){
			irradiance+="×10"+StringUtils.replaceToSquareChar(irradiance4);
		}
		return irradiance;
	}

	public String getIrradiance() {
		irradiance="";
		if(StringUtils.isNotEmpty(irradiance1)){
			irradiance+=irradiance1;
		}
		if(StringUtils.isNotEmpty(irradiance2)){
			irradiance+="×10<sup>"+irradiance2+"</sup>";
		}
		if(StringUtils.isNotEmpty(irradiance)&&(StringUtils.isNotEmpty(irradiance3)||StringUtils.isNotEmpty(irradiance4))){
			irradiance+="~";
		}
		if(StringUtils.isNotEmpty(irradiance3)){
			irradiance+=irradiance3;
		}
		if(StringUtils.isNotEmpty(irradiance4)){
			irradiance+="×10<sup>"+irradiance4+"</sup>";
		}
//		irradiance=irradiance1+"×10"+irradiance2+"~"+irradiance3+"×10"+irradiance4;
		return irradiance;
	}

	public void setIrradiance(String irradiance) {
		this.irradiance = irradiance;
	}

	public HcCheckPlan getHcCheckPlan() {
		return hcCheckPlan;
	}

	public void setHcCheckPlan(HcCheckPlan hcCheckPlan) {
		this.hcCheckPlan = hcCheckPlan;
	}

	public String getHarmSources() {
		return harmSources;
	}

	public void setHarmSources(String harmSources) {
		this.harmSources = harmSources;
	}

	public Long getWorkId() {
		return workId;
	}

	public void setWorkId(Long workId) {
		this.workId = workId;
	}

	public String getHarmId() {
		return harmId;
	}

	public void setHarmId(String harmId) {
		this.harmId = harmId;
	}

	public Date getSearchEndTime() {
		return searchEndTime;
	}

	public void setSearchEndTime(Date searchEndTime) {
		this.searchEndTime = searchEndTime;
	}
	
}