package cn.smarthse.modules.health.entity.work.hccheckplan;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckResultTypeEnum;

@Table(name = "hc_collect_ionizingradiation_v")
public class HcCollectIonizingradiationV implements Serializable {
	/**
	 * 查询结束时间
	 */
	@Transient
	private Date searchEndTime;
//	型号 modelnumber
//	额定容量
//	检测条件
//	场所名称
//	标号
//	出厂活度(Bq)	
	
	/**
	 * 型号 modelnumber
	 * 
	 */
	private String modelnumber;
	
	/**
	 * 额定容量
	 */
	private String ratedcapacity;
	/**
	 * 检测条件
	 */
	private String  detectionconditions;
	/**
	 * 标号
	 */
	private String  grade;
    
	/**
	 * 出厂活度(Bq)
	 */
	private String  activity1;
	
	/**
	 * 场所名称
	 */
	private String  place;
	
	/**
	 * 电离辐射子类型 1射线装置 2含源装置
	 */
	private String subtype;
	
	
	@Transient
	private String harmId;
	/**
	 * 岗位Id
	 */
	@Transient
	private Long workId;
	
	/**
	 * 危害来源即采样点
	 * 
	 */
	@Transient
	private String harmSources;
	
	@Transient
	private HcCheckPlan hcCheckPlan;
	
	@Transient
	private String checkresult;
	
	@Transient
	private String nuclide;
	
	/**
	 * 操作列
	 */
	@Transient
	private String operationStr;
	
	
	/**
	 * 判定结果名称
	 */
	@Transient
	private String resultName;
	
    /**
     * ID
     */
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病危害因素检测id
     */
    @Column(name = "hc_id")
    private Long hcId;

    /**
     * 行号标识
     */
    @Column(name = "row_flag")
    private String rowFlag;

    /**
     * hc_check_result_collect表的id
     */
    @Column(name = "result_collect_id")
    private Long resultCollectId;

    /**
     * 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    @Column(name = "is_selected")
    private Boolean isSelected;

    /**
     * 结果汇总类别（1到17见具体的枚举类）
     */
    @Column(name = "collect_type")
    private Byte collectType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 装置名称
     */
    @Column(name = "report_name")
    private String reportName;

    /**
     * 放射源编号
     */
    private String source;

    /**
     * 核素
     */
    private String nuclide1;

    /**
     * 核素
     */
    private String nuclide2;

    /**
     * 活度(Bq)
     */
    private String activity;

    /**
     * 位置
     */
    private String location;

    /**
     * 距离(cm)
     */
    private String distance;

    /**
     * 检测结果（μSv/h）
     */
    private String checkresult1;

    /**
     * 检测结果（μSv/h）
     */
    private String checkresult2;

    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病危害因素检测id
     *
     * @return hc_id - 职业病危害因素检测id
     */
    public Long getHcId() {
        return hcId;
    }

    /**
     * 设置职业病危害因素检测id
     *
     * @param hcId 职业病危害因素检测id
     */
    public void setHcId(Long hcId) {
        this.hcId = hcId;
    }

    /**
     * 获取行号标识
     *
     * @return row_flag - 行号标识
     */
    public String getRowFlag() {
        return rowFlag;
    }

    /**
     * 设置行号标识
     *
     * @param rowFlag 行号标识
     */
    public void setRowFlag(String rowFlag) {
        this.rowFlag = rowFlag == null ? null : rowFlag.trim();
    }

    /**
     * 获取hc_check_result_collect表的id
     *
     * @return result_collect_id - hc_check_result_collect表的id
     */
    public Long getResultCollectId() {
        return resultCollectId;
    }

    /**
     * 设置hc_check_result_collect表的id
     *
     * @param resultCollectId hc_check_result_collect表的id
     */
    public void setResultCollectId(Long resultCollectId) {
        this.resultCollectId = resultCollectId;
    }

    /**
     * 获取界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @return is_selected - 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public Boolean getIsSelected() {
        return isSelected;
    }

    /**
     * 设置界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @param isSelected 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    /**
     * 获取结果汇总类别（1到17见具体的枚举类）
     *
     * @return collect_type - 结果汇总类别（1到17见具体的枚举类）
     */
    public Byte getCollectType() {
        return collectType;
    }

    /**
     * 设置结果汇总类别（1到17见具体的枚举类）
     *
     * @param collectType 结果汇总类别（1到17见具体的枚举类）
     */
    public void setCollectType(Byte collectType) {
        this.collectType = collectType;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * @return report_name
     */
    public String getReportName() {
        return reportName;
    }

    /**
     * @param reportName
     */
    public void setReportName(String reportName) {
        this.reportName = reportName == null ? null : reportName.trim();
    }

    /**
     * @return source
     */
    public String getSource() {
        return source;
    }

    /**
     * @param source
     */
    public void setSource(String source) {
        this.source = source == null ? null : source.trim();
    }

    /**
     * @return nuclide1
     */
    public String getNuclide1() {
        return nuclide1;
    }

    /**
     * @param nuclide1
     */
    public void setNuclide1(String nuclide1) {
        this.nuclide1 = nuclide1 == null ? null : nuclide1.trim();
    }

    /**
     * @return nuclide2
     */
    public String getNuclide2() {
        return nuclide2;
    }

    /**
     * @param nuclide2
     */
    public void setNuclide2(String nuclide2) {
        this.nuclide2 = nuclide2 == null ? null : nuclide2.trim();
    }

    /**
     * @return activity
     */
    public String getActivity() {
        return activity;
    }

    /**
     * @param activity
     */
    public void setActivity(String activity) {
        this.activity = activity == null ? null : activity.trim();
    }

    /**
     * @return location
     */
    public String getLocation() {
        return location;
    }

    /**
     * @param location
     */
    public void setLocation(String location) {
        this.location = location == null ? null : location.trim();
    }

    /**
     * @return distance
     */
    public String getDistance() {
        return distance;
    }

    /**
     * @param distance
     */
    public void setDistance(String distance) {
        this.distance = distance == null ? null : distance.trim();
    }

    /**
     * @return checkresult1
     */
    public String getCheckresult1() {
        return checkresult1;
    }

    /**
     * @param checkresult1
     */
    public void setCheckresult1(String checkresult1) {
        this.checkresult1 = checkresult1 == null ? null : checkresult1.trim();
    }

    /**
     * @return checkresult2
     */
    public String getCheckresult2() {
        return checkresult2;
    }

    /**
     * @param checkresult2
     */
    public void setCheckresult2(String checkresult2) {
        this.checkresult2 = checkresult2 == null ? null : checkresult2.trim();
    }

    /**
     * @return result
     */
    public String getResult() {
        return result;
    }

    /**
     * @param result
     */
    public void setResult(String result) {
        this.result = result == null ? null : result.trim();
    }
    
    public String getResultName() {
//		if(StringUtils.isNotEmpty(result)){
//    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result)){
//    			resultName=HcCheckResultTypeEnum.ACCORD.getName();
//    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result)){
//    			resultName=HcCheckResultTypeEnum.NOTACCORD.getName();
//    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result)){
//    			resultName=HcCheckResultTypeEnum.NONJUDGMENT.getName();
//    		}
//    	}
		
    	return  "<a href=\"javascript:editIonizingRadiationCheckResutlPage('"+id+"');\" class='ui-pg-div ml5' title='编辑检测结果'><i class='ui-icon icon-pencil bigger-110 green'></i></a>";
	}

	public void setResultName(String resultName) {
		this.resultName = resultName;
	}
	public String getOperationStr() {
		return "<a href=\"javascript:cloneCollectChemical('"+id+"','"+subtype+"');\" class='ui-pg-div ml5' title='克隆' ><i class='ui-icon icon-ui-icon icon-copy green'></i></a>"
				+ "<a href=\"javascript:editCollectChemical('"+id+"','"+subtype+"');\" class='ui-pg-div ml5' title='编辑'><i class='ui-icon icon-pencil bigger-110 green'></i></a>"
				+ "<a href=\"javascript:deleteCollectChemicalByDataId('"+id+"','"+subtype+"');\" class='ui-pg-div ml5' title='删除'><i class='ui-icon icon-trash red'></i></a>";
	}

	public void setOperationStr(String operationStr) {
		this.operationStr = operationStr;
	}

	public String getNuclide() {
		nuclide="";
		if(StringUtils.isNotEmpty(nuclide1)){
			nuclide+=nuclide1;
		}
		if(StringUtils.isNotEmpty(nuclide)&&StringUtils.isNotEmpty(nuclide2)){
			nuclide+="-";
		}
        if(StringUtils.isNotEmpty(nuclide2)){
        	nuclide+=nuclide2;
		}
		
//		nuclide=nuclide1+"~"+nuclide2;
		return nuclide;
	}

	public void setNuclide(String nuclide) {
		this.nuclide = nuclide;
	}

	public String getCheckresult() {
		checkresult="";
		if(StringUtils.isNotEmpty(checkresult1)){
			checkresult+=checkresult1;
		}
		if(StringUtils.isNotEmpty(checkresult)&&StringUtils.isNotEmpty(checkresult2)){
			checkresult+="~";
		}
        if(StringUtils.isNotEmpty(checkresult2)){
        	checkresult+=checkresult2;
		}
//		checkresult=checkresult1+"~"+checkresult2;
		return checkresult;
	}

	public void setCheckresult(String checkresult) {
		this.checkresult = checkresult;
	}

	public HcCheckPlan getHcCheckPlan() {
		return hcCheckPlan;
	}

	public void setHcCheckPlan(HcCheckPlan hcCheckPlan) {
		this.hcCheckPlan = hcCheckPlan;
	}

	public String getHarmSources() {
		return harmSources;
	}

	public void setHarmSources(String harmSources) {
		this.harmSources = harmSources;
	}

	public Long getWorkId() {
		return workId;
	}

	public void setWorkId(Long workId) {
		this.workId = workId;
	}

	public String getHarmId() {
		return harmId;
	}

	public void setHarmId(String harmId) {
		this.harmId = harmId;
	}
	
	public String getSubtype() {
		return subtype;
	}

	public void setSubtype(String subtype) {
		this.subtype = subtype;
	}

	public String getModelnumber() {
		return modelnumber;
	}

	public void setModelnumber(String modelnumber) {
		this.modelnumber = modelnumber;
	}

	public String getRatedcapacity() {
		return ratedcapacity;
	}

	public void setRatedcapacity(String ratedcapacity) {
		this.ratedcapacity = ratedcapacity;
	}

	public String getDetectionconditions() {
		return detectionconditions;
	}

	public void setDetectionconditions(String detectionconditions) {
		this.detectionconditions = detectionconditions;
	}

	public String getGrade() {
		return grade;
	}

	public void setGrade(String grade) {
		this.grade = grade;
	}

	public String getActivity1() {
		return activity1;
	}

	public void setActivity1(String activity1) {
		this.activity1 = activity1;
	}

	public String getPlace() {
		return place;
	}

	public void setPlace(String place) {
		this.place = place;
	}

	public Date getSearchEndTime() {
		return searchEndTime;
	}

	public void setSearchEndTime(Date searchEndTime) {
		this.searchEndTime = searchEndTime;
	}
	
}