package cn.smarthse.modules.health.entity.work.hccheckplan;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckResultTypeEnum;

@Table(name = "hc_collect_dust_v")
public class HcCollectDustV implements Serializable {
	/**
	 * 查询结束时间
	 */
	@Transient
	private Date searchEndTime;
	/**
	 * 岗位Id
	 */
	@Transient
	private Long workId;
	
	/**
	 * 危害来源即采样点
	 * 
	 */
	@Transient
	private String harmSources;
	
	/**
	 * 危害因素Ids
	 */
	@Transient
	private  String harmIds;
	
	/**
	 * 危害因素
	 */
	@Transient
	private OccupationalRiskFactors  riskFactors;
	
	@Transient
	private HcCheckPlan hcCheckPlan;
	
	
	@Transient
	private String resultName;
	
	@Transient
	private String resultName1;
	
	/**
	 * 操作列
	 */
	@Transient
	private String operationStr;
	
    /**
     * ID
     */
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病危害因素检测id
     */
    @Column(name = "hc_id")
    private Long hcId;

    /**
     * 行号标识
     */
    @Column(name = "row_flag")
    private String rowFlag;

    /**
     * hc_check_result_collect表的id
     */
    @Column(name = "result_collect_id")
    private Long resultCollectId;

    /**
     * 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    @Column(name = "is_selected")
    private Boolean isSelected;

    /**
     * 结果汇总类别（1到17见具体的枚举类）
     */
    @Column(name = "collect_type")
    private Byte collectType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 采样点/对象
     */
    @Column(name = "report_name")
    private String reportName;

    /**
     * 具体的危害因素Id
     */
    @Column(name = "check_proj")
    private String checkProj;

    /**
     * C<sub>TWA</sub>总尘(mg/m³)
     */
    private String ctwa1;

    /**
     * 超限倍数(总尘)
     */
    private String times1;

    /**
     * C<sub>TWA</sub>呼尘(mg/m³)
     */
    private String ctwa2;

    /**
     * 超限倍数(呼尘)
     */
    private String times2;

    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result;
    
    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result1;
    
    private String ctwa1range00;
    private String ctwa1range0;
    private String ctwa1range;
    @Transient
    private String ctwa1rangeval;
    
    private String ctwa2range00;
    private String ctwa2range0;
    private String ctwa2range;
    @Transient
    private String ctwa2rangeval;
    
    /**
     * 总尘（峰值）
     */
    private String peakcontactconcentration1;
    
    /**
     * 呼尘（峰值）
     */
    private String peakcontactconcentration2;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病危害因素检测id
     *
     * @return hc_id - 职业病危害因素检测id
     */
    public Long getHcId() {
        return hcId;
    }

    /**
     * 设置职业病危害因素检测id
     *
     * @param hcId 职业病危害因素检测id
     */
    public void setHcId(Long hcId) {
        this.hcId = hcId;
    }

    /**
     * 获取行号标识
     *
     * @return row_flag - 行号标识
     */
    public String getRowFlag() {
        return rowFlag;
    }

    /**
     * 设置行号标识
     *
     * @param rowFlag 行号标识
     */
    public void setRowFlag(String rowFlag) {
        this.rowFlag = rowFlag == null ? null : rowFlag.trim();
    }

    /**
     * 获取hc_check_result_collect表的id
     *
     * @return result_collect_id - hc_check_result_collect表的id
     */
    public Long getResultCollectId() {
        return resultCollectId;
    }

    /**
     * 设置hc_check_result_collect表的id
     *
     * @param resultCollectId hc_check_result_collect表的id
     */
    public void setResultCollectId(Long resultCollectId) {
        this.resultCollectId = resultCollectId;
    }

    /**
     * 获取界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @return is_selected - 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public Boolean getIsSelected() {
        return isSelected;
    }

    /**
     * 设置界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @param isSelected 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    /**
     * 获取结果汇总类别（1到17见具体的枚举类）
     *
     * @return collect_type - 结果汇总类别（1到17见具体的枚举类）
     */
    public Byte getCollectType() {
        return collectType;
    }

    /**
     * 设置结果汇总类别（1到17见具体的枚举类）
     *
     * @param collectType 结果汇总类别（1到17见具体的枚举类）
     */
    public void setCollectType(Byte collectType) {
        this.collectType = collectType;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * @return report_name
     */
    public String getReportName() {
        return reportName;
    }

    /**
     * @param reportName
     */
    public void setReportName(String reportName) {
        this.reportName = reportName == null ? null : reportName.trim();
    }

    /**
     * @return check_proj
     */
    public String getCheckProj() {
        return checkProj;
    }

    /**
     * @param checkProj
     */
    public void setCheckProj(String checkProj) {
        this.checkProj = checkProj == null ? null : checkProj.trim();
    }

    /**
     * @return ctwa1
     */
    public String getCtwa1() {
        return ctwa1;
    }

    /**
     * @param ctwa1
     */
    public void setCtwa1(String ctwa1) {
        this.ctwa1 = ctwa1 == null ? null : ctwa1.trim();
    }

    /**
     * @return times1
     */
    public String getTimes1() {
        return times1;
    }

    /**
     * @param times1
     */
    public void setTimes1(String times1) {
        this.times1 = times1 == null ? null : times1.trim();
    }

    /**
     * @return ctwa2
     */
    public String getCtwa2() {
        return ctwa2;
    }

    /**
     * @param ctwa2
     */
    public void setCtwa2(String ctwa2) {
        this.ctwa2 = ctwa2 == null ? null : ctwa2.trim();
    }

    /**
     * @return times2
     */
    public String getTimes2() {
        return times2;
    }

    /**
     * @param times2
     */
    public void setTimes2(String times2) {
        this.times2 = times2 == null ? null : times2.trim();
    }

    /**
     * @return result
     */
    public String getResult() {
        return result;
    }

    /**
     * @param result
     */
    public void setResult(String result) {
        this.result = result == null ? null : result.trim();
    }
    
    public String getResultName() {
		if(StringUtils.isNotEmpty(result)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}
    	}
		
		return resultName;
	}

	public void setResultName(String resultName) {
		this.resultName = resultName;
	}
	public String getOperationStr() {
		return "<a href=\"javascript:cloneCollectChemical('"+id+"');\" class='ui-pg-div ml5' title='克隆' ><i class='ui-icon icon-ui-icon icon-copy green'></i></a>"
				+ "<a href=\"javascript:editCollectChemical('"+id+"');\" class='ui-pg-div ml5' title='编辑'><i class='ui-icon icon-pencil bigger-110 green'></i></a>"
				+ "<a href=\"javascript:deleteCollectChemicalByDataId('"+id+"');\" class='ui-pg-div ml5' title='删除'><i class='ui-icon icon-trash red'></i></a>";
	}

	public void setOperationStr(String operationStr) {
		this.operationStr = operationStr;
	}

	public HcCheckPlan getHcCheckPlan() {
		return hcCheckPlan;
	}

	public void setHcCheckPlan(HcCheckPlan hcCheckPlan) {
		this.hcCheckPlan = hcCheckPlan;
	}

	public OccupationalRiskFactors getRiskFactors() {
		return riskFactors;
	}

	public void setRiskFactors(OccupationalRiskFactors riskFactors) {
		this.riskFactors = riskFactors;
	}

	public String getHarmIds() {
		return harmIds;
	}

	public void setHarmIds(String harmIds) {
		this.harmIds = harmIds;
	}

	public String getHarmSources() {
		return harmSources;
	}

	public void setHarmSources(String harmSources) {
		this.harmSources = harmSources;
	}

	public Long getWorkId() {
		return workId;
	}

	public void setWorkId(Long workId) {
		this.workId = workId;
	}
	
	public String getCtwa1range() {
		return ctwa1range;
	}

	public void setCtwa1range(String ctwa1range) {
		this.ctwa1range = ctwa1range;
	}

	public String getCtwa2range() {
		return ctwa2range;
	}

	public void setCtwa2range(String ctwa2range) {
		this.ctwa2range = ctwa2range;
	}

	public String getResult1() {
		return result1;
	}

	public void setResult1(String result1) {
		this.result1 = result1;
	}
	public String getResultName1() {
		if(StringUtils.isNotEmpty(result1)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result1)){
    			resultName1=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result1)){
    			resultName1=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result1)){
    			resultName1=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}
     }
		return resultName1;
	}

	public void setResultName1(String resultName1) {
		this.resultName1 = resultName1;
	}

	public String getPeakcontactconcentration1() {
		return peakcontactconcentration1;
	}

	public void setPeakcontactconcentration1(String peakcontactconcentration1) {
		this.peakcontactconcentration1 = peakcontactconcentration1;
	}

	public String getPeakcontactconcentration2() {
		return peakcontactconcentration2;
	}

	public void setPeakcontactconcentration2(String peakcontactconcentration2) {
		this.peakcontactconcentration2 = peakcontactconcentration2;
	}

	public Date getSearchEndTime() {
		return searchEndTime;
	}

	public void setSearchEndTime(Date searchEndTime) {
		this.searchEndTime = searchEndTime;
	}
	

	public String getCtwa1range00() {
		return ctwa1range00;
	}

	public void setCtwa1range00(String ctwa1range00) {
		this.ctwa1range00 = ctwa1range00;
	}

	public String getCtwa1range0() {
		return ctwa1range0;
	}

	public void setCtwa1range0(String ctwa1range0) {
		this.ctwa1range0 = ctwa1range0;
	}

	public String getCtwa2range00() {
		return ctwa2range00;
	}

	public void setCtwa2range00(String ctwa2range00) {
		this.ctwa2range00 = ctwa2range00;
	}

	public String getCtwa2range0() {
		return ctwa2range0;
	}

	public void setCtwa2range0(String ctwa2range0) {
		this.ctwa2range0 = ctwa2range0;
	}

	public String getCtwa1rangeval() {

		ctwa1rangeval = "";

		if (StringUtils.isNotEmpty(ctwa1range00) && StringUtils.isNumber(ctwa1range00)) {

			if (Integer.valueOf(NumberUtil.toInt(ctwa1range00.trim())) == 1) {
				ctwa1rangeval += "＜";
			} else if (Integer.valueOf(NumberUtil.toInt(ctwa1range00.trim())) == 2) {
				ctwa1rangeval += "≤";
			}
		}
		if (StringUtils.isNotEmpty(ctwa1range0)) {
			ctwa1rangeval += ctwa1range0;
		}
		if (StringUtils.isNotEmpty(ctwa1rangeval) && StringUtils.isNotEmpty(ctwa1range0)) {
			ctwa1rangeval += "~";
		}
		if (StringUtils.isNotEmpty(ctwa1range)) {
			ctwa1rangeval += ctwa1range;
		}

		return ctwa1rangeval;
	}

	public void setCtwa1rangeval(String ctwa1rangeval) {
		this.ctwa1rangeval = ctwa1rangeval;
	}

	public String getCtwa2rangeval() {

		ctwa2rangeval = "";

		if (StringUtils.isNotEmpty(ctwa2range00) && StringUtils.isNumber(ctwa2range00)) {

			if (Integer.valueOf(NumberUtil.toInt(ctwa2range00.trim())) == 1) {
				ctwa2rangeval += "＜";
			} else if (Integer.valueOf(NumberUtil.toInt(ctwa2range00.trim())) == 2) {
				ctwa2rangeval += "≤";
			}
		}
		if (StringUtils.isNotEmpty(ctwa2range0)) {
			ctwa2rangeval += ctwa2range0;
		}
		if (StringUtils.isNotEmpty(ctwa2rangeval) && StringUtils.isNotEmpty(ctwa2range)) {
			ctwa2rangeval += "~";
		}
		if (StringUtils.isNotEmpty(ctwa2range)) {
			ctwa2rangeval += ctwa2range;
		}
		
		return ctwa2rangeval;
	}

	public void setCtwa2rangeval(String ctwa2rangeval) {
		this.ctwa2rangeval = ctwa2rangeval;
	}
	
}