package cn.smarthse.modules.health.entity.work.hccheckplan;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckResultTypeEnum;

@Table(name = "hc_collect_biological_factor_v")
public class HcCollectBiologicalFactorV implements Serializable {
	/**
	 * 查询结束时间
	 */
	@Transient
	private Date searchEndTime;
	/**
	 * 岗位Id
	 */
	@Transient
	private Long workId;
	
	/**
	 * 危害来源即采样点
	 * 
	 */
	@Transient
	private String harmSources;
	
	/**
	 * 危害因素Ids
	 */
	@Transient
	private  String harmIds;
	
	/**
	 * 危害因素
	 */
	@Transient
	private OccupationalRiskFactors  riskFactors;
	
	@Transient
	private HcCheckPlan hcCheckPlan;
	
	@Transient
	private String time;
	
	@Transient
	private String cstel;
	
	@Transient
	private String ctwa;
	
	@Transient
	private String cmac;
	
	
	@Transient
	private String resultName;
	
	/**
	 * 操作列
	 */
	@Transient
	private String operationStr;
	
    /**
     * ID
     */
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select right(uuid_short(),19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病危害因素检测id
     */
    @Column(name = "hc_id")
    private Long hcId;

    /**
     * 行号标识
     */
    @Column(name = "row_flag")
    private String rowFlag;

    /**
     * hc_check_result_collect表的id
     */
    @Column(name = "result_collect_id")
    private Long resultCollectId;

    /**
     * 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    @Column(name = "is_selected")
    private Boolean isSelected;

    /**
     * 结果汇总类别（1到17见具体的枚举类）
     */
    @Column(name = "collect_type")
    private Byte collectType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 采样点/对象
     */
    @Column(name = "report_name")
    private String reportName;

    /**
     * 具体的危害因素Id
     */
    @Column(name = "check_proj")
    private String checkProj;

    /**
     * 值
     */
    private String cmac1;

    /**
     * 单位
     */
    private String cmac2;

    /**
     * 值
     */
    private String ctwa1;

    /**
     * 单位
     */
    private String ctwa2;

    /**
     * 0：－；1：＜；2：≤
     */
    private String cstel1;

    /**
     * 值
     */
    private String cstel2;

    /**
     * 值
     */
    private String cstel3;

    /**
     * 单位
     */
    private String cstel4;

    private String times;

    private String ctwa11;

    private String cstel13;

    private String cstel14;

    private String cstel15;

    private String cmac11;

    private String cmac12;

    /**
     * 0:符合,1:不符合,2:不判定
     */
    private String result;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病危害因素检测id
     *
     * @return hc_id - 职业病危害因素检测id
     */
    public Long getHcId() {
        return hcId;
    }

    /**
     * 设置职业病危害因素检测id
     *
     * @param hcId 职业病危害因素检测id
     */
    public void setHcId(Long hcId) {
        this.hcId = hcId;
    }

    /**
     * 获取行号标识
     *
     * @return row_flag - 行号标识
     */
    public String getRowFlag() {
        return rowFlag;
    }

    /**
     * 设置行号标识
     *
     * @param rowFlag 行号标识
     */
    public void setRowFlag(String rowFlag) {
        this.rowFlag = rowFlag == null ? null : rowFlag.trim();
    }

    /**
     * 获取hc_check_result_collect表的id
     *
     * @return result_collect_id - hc_check_result_collect表的id
     */
    public Long getResultCollectId() {
        return resultCollectId;
    }

    /**
     * 设置hc_check_result_collect表的id
     *
     * @param resultCollectId hc_check_result_collect表的id
     */
    public void setResultCollectId(Long resultCollectId) {
        this.resultCollectId = resultCollectId;
    }

    /**
     * 获取界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @return is_selected - 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public Boolean getIsSelected() {
        return isSelected;
    }

    /**
     * 设置界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @param isSelected 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    /**
     * 获取结果汇总类别（1到17见具体的枚举类）
     *
     * @return collect_type - 结果汇总类别（1到17见具体的枚举类）
     */
    public Byte getCollectType() {
        return collectType;
    }

    /**
     * 设置结果汇总类别（1到17见具体的枚举类）
     *
     * @param collectType 结果汇总类别（1到17见具体的枚举类）
     */
    public void setCollectType(Byte collectType) {
        this.collectType = collectType;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * @return report_name
     */
    public String getReportName() {
        return reportName;
    }

    /**
     * @param reportName
     */
    public void setReportName(String reportName) {
        this.reportName = reportName == null ? null : reportName.trim();
    }

    /**
     * @return check_proj
     */
    public String getCheckProj() {
        return checkProj;
    }

    /**
     * @param checkProj
     */
    public void setCheckProj(String checkProj) {
        this.checkProj = checkProj == null ? null : checkProj.trim();
    }

    /**
     * @return cmac1
     */
    public String getCmac1() {
        return cmac1;
    }

    /**
     * @param cmac1
     */
    public void setCmac1(String cmac1) {
        this.cmac1 = cmac1 == null ? null : cmac1.trim();
    }

    /**
     * @return cmac2
     */
    public String getCmac2() {
        return cmac2;
    }

    /**
     * @param cmac2
     */
    public void setCmac2(String cmac2) {
        this.cmac2 = cmac2 == null ? null : cmac2.trim();
    }

    /**
     * @return ctwa1
     */
    public String getCtwa1() {
        return ctwa1;
    }

    /**
     * @param ctwa1
     */
    public void setCtwa1(String ctwa1) {
        this.ctwa1 = ctwa1 == null ? null : ctwa1.trim();
    }

    /**
     * @return ctwa2
     */
    public String getCtwa2() {
        return ctwa2;
    }

    /**
     * @param ctwa2
     */
    public void setCtwa2(String ctwa2) {
        this.ctwa2 = ctwa2 == null ? null : ctwa2.trim();
    }

    /**
     * @return cstel1
     */
    public String getCstel1() {
        return cstel1;
    }

    /**
     * @param cstel1
     */
    public void setCstel1(String cstel1) {
        this.cstel1 = cstel1 == null ? null : cstel1.trim();
    }

    /**
     * @return cstel2
     */
    public String getCstel2() {
        return cstel2;
    }

    /**
     * @param cstel2
     */
    public void setCstel2(String cstel2) {
        this.cstel2 = cstel2 == null ? null : cstel2.trim();
    }

    /**
     * @return cstel3
     */
    public String getCstel3() {
        return cstel3;
    }

    /**
     * @param cstel3
     */
    public void setCstel3(String cstel3) {
        this.cstel3 = cstel3 == null ? null : cstel3.trim();
    }

    /**
     * @return cstel4
     */
    public String getCstel4() {
        return cstel4;
    }

    /**
     * @param cstel4
     */
    public void setCstel4(String cstel4) {
        this.cstel4 = cstel4 == null ? null : cstel4.trim();
    }

    /**
     * @return times
     */
    public String getTimes() {
        return times;
    }

    /**
     * @param times
     */
    public void setTimes(String times) {
        this.times = times == null ? null : times.trim();
    }

    /**
     * @return ctwa11
     */
    public String getCtwa11() {
        return ctwa11;
    }

    /**
     * @param ctwa11
     */
    public void setCtwa11(String ctwa11) {
        this.ctwa11 = ctwa11 == null ? null : ctwa11.trim();
    }

    /**
     * @return cstel13
     */
    public String getCstel13() {
        return cstel13;
    }

    /**
     * @param cstel13
     */
    public void setCstel13(String cstel13) {
        this.cstel13 = cstel13 == null ? null : cstel13.trim();
    }

    /**
     * @return cstel14
     */
    public String getCstel14() {
        return cstel14;
    }

    /**
     * @param cstel14
     */
    public void setCstel14(String cstel14) {
        this.cstel14 = cstel14 == null ? null : cstel14.trim();
    }

    /**
     * @return cstel15
     */
    public String getCstel15() {
        return cstel15;
    }

    /**
     * @param cstel15
     */
    public void setCstel15(String cstel15) {
        this.cstel15 = cstel15 == null ? null : cstel15.trim();
    }

    /**
     * @return cmac11
     */
    public String getCmac11() {
        return cmac11;
    }

    /**
     * @param cmac11
     */
    public void setCmac11(String cmac11) {
        this.cmac11 = cmac11 == null ? null : cmac11.trim();
    }

    /**
     * @return cmac12
     */
    public String getCmac12() {
        return cmac12;
    }

    /**
     * @param cmac12
     */
    public void setCmac12(String cmac12) {
        this.cmac12 = cmac12 == null ? null : cmac12.trim();
    }

    /**
     * @return result
     */
    public String getResult() {
        return result;
    }

    /**
     * @param result
     */
    public void setResult(String result) {
        this.result = result == null ? null : result.trim();
    }
    public String getResultName() {
		if(StringUtils.isNotEmpty(result)){
    		if(HcCheckResultTypeEnum.ACCORD.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.ACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NOTACCORD.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.NOTACCORD.getName();
    		}else if(HcCheckResultTypeEnum.NONJUDGMENT.getCode().toString().equals(result)){
    			resultName=HcCheckResultTypeEnum.NONJUDGMENT.getName();
    		}
    	}
		
		return resultName;
	}

	public void setResultName(String resultName) {
		this.resultName = resultName;
	}
	public String getOperationStr() {
		return "<a href=\"javascript:cloneCollectChemical('"+id+"');\" class='ui-pg-div ml5' title='克隆' ><i class='ui-icon icon-ui-icon icon-copy green'></i></a>"
				+ "<a href=\"javascript:editCollectChemical('"+id+"');\" class='ui-pg-div ml5' title='编辑'><i class='ui-icon icon-pencil bigger-110 green'></i></a>"
				+ "<a href=\"javascript:deleteCollectChemicalByDataId('"+id+"');\" class='ui-pg-div ml5' title='删除'><i class='ui-icon icon-trash red'></i></a>";
	}

	public void setOperationStr(String operationStr) {
		this.operationStr = operationStr;
	}

	public String getCmac() {
//		cmac=cmac1+cmac2+cmac11+cmac12;
		cmac="";
        if(StringUtils.isNotEmpty(cmac1)){
        	cmac+=cmac1;
        }
	    if(StringUtils.isNotEmpty(cmac)&&StringUtils.isNotEmpty(cmac2)){
	    	cmac+=cmac2;
	    }
		return cmac;
	}

	public void setCmac(String cmac) {
		this.cmac = cmac;
	}

	public String getCtwa() {
//		ctwa=ctwa1+ctwa2+ctwa11;
		ctwa="";
		if(StringUtils.isNotEmpty(ctwa1)){
			ctwa+=ctwa1;
		}
		if(StringUtils.isNotEmpty(ctwa)&&StringUtils.isNotEmpty(ctwa2)){
			ctwa+=ctwa2;
		}
		return ctwa;
	}

	public void setCtwa(String ctwa) {
		this.ctwa = ctwa;
	}
	
	/**
	 * cstel档案用
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年10月26日-下午2:57:00
	 * @return
	 */
	public String getCstelForArchive(){

//		cstel=cstel1+cstel2+cstel3+cstel4+cstel13+cstel14+cstel15;
		cstel="";
		if(StringUtils.isNotEmpty(cstel1)&&StringUtils.isNumber(cstel1)){
		   if(Integer.valueOf(cstel1.trim())==1){
			   cstel+="＜";
		   }else if(Integer.valueOf(cstel1.trim())==2){
			   cstel+="≤";
		   }
		}
		if(StringUtils.isNotEmpty(cstel2)){
			cstel+=cstel2;
		}
		if(StringUtils.isNotEmpty(cstel)&&(StringUtils.isNotEmpty(cstel3)&&StringUtils.isNotEmpty(cstel4))){
			cstel+="~";
		}
		if(StringUtils.isNotEmpty(cstel3)){
			cstel+=cstel3;
		}
		return cstel;
	
	}

	public String getCstel() {
//		cstel=cstel1+cstel2+cstel3+cstel4+cstel13+cstel14+cstel15;
		cstel="";
		if(StringUtils.isNotEmpty(cstel1)&&StringUtils.isNumber(cstel1)){
		   if(Integer.valueOf(cstel1.trim())==1){
			   cstel+="＜";
		   }else if(Integer.valueOf(cstel1.trim())==2){
			   cstel+="≤";
		   }
		}
		if(StringUtils.isNotEmpty(cstel2)){
			cstel+=cstel2;
		}
		if(StringUtils.isNotEmpty(cstel)&&StringUtils.isNotEmpty(cstel3)){
			cstel+="~";
		}
		if(StringUtils.isNotEmpty(cstel3)){
			cstel+=cstel3;
		}
		if(StringUtils.isNotEmpty(cstel)&&StringUtils.isNotEmpty(cstel4)){
			cstel+=cstel4;
		}
		return cstel;
	}

	public void setCstel(String cstel) {
		this.cstel = cstel;
	}

	public String getTime() {
		time=times;
		return time;
	}

	public void setTime(String time) {
		this.time = time;
	}

	public HcCheckPlan getHcCheckPlan() {
		return hcCheckPlan;
	}

	public void setHcCheckPlan(HcCheckPlan hcCheckPlan) {
		this.hcCheckPlan = hcCheckPlan;
	}

	public OccupationalRiskFactors getRiskFactors() {
		return riskFactors;
	}

	public void setRiskFactors(OccupationalRiskFactors riskFactors) {
		this.riskFactors = riskFactors;
	}

	public String getHarmIds() {
		return harmIds;
	}

	public void setHarmIds(String harmIds) {
		this.harmIds = harmIds;
	}

	public String getHarmSources() {
		return harmSources;
	}

	public void setHarmSources(String harmSources) {
		this.harmSources = harmSources;
	}

	public Long getWorkId() {
		return workId;
	}

	public void setWorkId(Long workId) {
		this.workId = workId;
	}

	public Date getSearchEndTime() {
		return searchEndTime;
	}

	public void setSearchEndTime(Date searchEndTime) {
		this.searchEndTime = searchEndTime;
	}
	
}