package cn.smarthse.modules.health.entity.work.hccheckplan;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "hc_check_third_org")
public class HcCheckThirdOrg implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 第三方应用服务机构id
     */
    @Column(name = "third_org_id")
    private Long thirdOrgId;

    /**
     * 第三方应用服务机构名称
     */
    @Column(name = "third_org_name")
    private String thirdOrgName;

    /**
     * 是否有效(1-有效,0-无效)
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    
    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取第三方应用服务机构id
     *
     * @return third_org_id - 第三方应用服务机构id
     */
    public Long getThirdOrgId() {
        return thirdOrgId;
    }

    /**
     * 设置第三方应用服务机构id
     *
     * @param thirdOrgId 第三方应用服务机构id
     */
    public void setThirdOrgId(Long thirdOrgId) {
        this.thirdOrgId = thirdOrgId;
    }

    /**
     * 获取第三方应用服务机构名称
     *
     * @return third_org_name - 第三方应用服务机构名称
     */
    public String getThirdOrgName() {
        return thirdOrgName;
    }

    /**
     * 设置第三方应用服务机构名称
     *
     * @param thirdOrgName 第三方应用服务机构名称
     */
    public void setThirdOrgName(String thirdOrgName) {
        this.thirdOrgName = thirdOrgName == null ? null : thirdOrgName.trim();
    }

    /**
     * 获取是否有效(1-有效,0-无效)
     *
     * @return is_valid - 是否有效(1-有效,0-无效)
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效(1-有效,0-无效)
     *
     * @param isValid 是否有效(1-有效,0-无效)
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
    public Long getCreateBy() {
		return createBy;
	}
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
	public Date getCreateDate() {
		return createDate;
	}
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	public Long getUpdateBy() {
		return updateBy;
	}
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
	public Date getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
}