package cn.smarthse.modules.health.entity.work.hccheckplan;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckAttachment;

@Table(name = "hc_check_result_report")
public class HcCheckResultReport implements Serializable {
	
	@Transient
	private List<HcCheckAttachment>  attachments;
	
	@Transient
	private String updator;
	
	@Transient
	private String checkOrgName;
	
	@Transient
	private String checkTypeName;
	
	@Transient
	private Long[] reportFileIdArr;
	
   	
	/**
	 * 检测时间
	 */
	@Transient
	private String checkDate;
	
	@Transient
	private HcCheckPlan hcCheckPlan;
	
	/**
	 * 第三机构Id
	 */
	@Transient
	private Long thirdPartyId;
	
	/**
	 * 检测类型
	 */
	@Transient
	private Long checkType;
	
	/**
	 * 结束检测时间
	 */
	@Transient
	private Date endCheckDate;
	
	/**
	 * 开始检测时间
	 */
	@Transient
	private Date startCheckDate;
    
	/**
     * 结束上报上报时间
     */
	@Transient
    private Date endReportDate;
	
	/**
     * 开始上报时间
     */
	@Transient
    private Date startReportDate;
	
	/**
	 * 
	 */
	@Transient
	private String searchKey;
	
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select right(uuid_short(),19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病危害因素检测id
     */
    @Column(name = "hc_id")
    private Long hcId;

    /**
     * 上报时间
     */
    @Column(name = "report_date")
    private Date reportDate;

    /**
     * 报告文件id(多个文件以逗号隔开)
     */
    @Column(name = "report_file_ids")
    private String reportFileIds;

    /**
     * 档案存放位置
     */
    @Column(name = "files_storage_location")
    private String filesStorageLocation;
    
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 档案负责人
     */
    @Column(name = "paper_manager")
    private Long paperManager;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 状态（0，未完成；1，已完成；）
     */
    private Byte status;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病危害因素检测id
     *
     * @return hc_id - 职业病危害因素检测id
     */
    public Long getHcId() {
        return hcId;
    }

    /**
     * 设置职业病危害因素检测id
     *
     * @param hcId 职业病危害因素检测id
     */
    public void setHcId(Long hcId) {
        this.hcId = hcId;
    }

    /**
     * 获取上报时间
     *
     * @return report_date - 上报时间
     */
    public Date getReportDate() {
        return reportDate;
    }

    /**
     * 设置上报时间
     *
     * @param reportDate 上报时间
     */
    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    /**
     * 获取报告文件id(多个文件以逗号隔开)
     *
     * @return report_file_ids - 报告文件id(多个文件以逗号隔开)
     */
    public String getReportFileIds() {
    	      if(StringUtils.isNotEmpty(reportFileIds)) {
    	    	  reportFileIds=reportFileIds.replace("null", "");
    	      }
        return reportFileIds;
    }

    /**
     * 设置报告文件id(多个文件以逗号隔开)
     *
     * @param reportFileIds 报告文件id(多个文件以逗号隔开)
     */
    public void setReportFileIds(String reportFileIds) {
        this.reportFileIds = reportFileIds == null ? null : reportFileIds.trim();
    }

    /**
     * 获取档案存放位置
     *
     * @return files_storage_location - 档案存放位置
     */
    public String getFilesStorageLocation() {
        return filesStorageLocation;
    }

    /**
     * 设置档案存放位置
     *
     * @param filesStorageLocation 档案存放位置
     */
    public void setFilesStorageLocation(String filesStorageLocation) {
        this.filesStorageLocation = filesStorageLocation == null ? null : filesStorageLocation.trim();
    }

    /**
     * 获取档案负责人
     *
     * @return paper_manager - 档案负责人
     */
    public Long getPaperManager() {
        return paperManager;
    }

    /**
     * 设置档案负责人
     *
     * @param paperManager 档案负责人
     */
    public void setPaperManager(Long paperManager) {
        this.paperManager = paperManager;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取状态（0，未完成；1，已完成；）
     *
     * @return status - 状态（0，未完成；1，已完成；）
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态（0，未完成；1，已完成；）
     *
     * @param status 状态（0，未完成；1，已完成；2:作废）
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public String getSearchKey() {
		return searchKey;
	}

	public void setSearchKey(String searchKey) {
		this.searchKey = searchKey;
	}

	public Date getStartReportDate() {
		return startReportDate;
	}

	public void setStartReportDate(Date startReportDate) {
		this.startReportDate = startReportDate;
	}

	public Date getEndReportDate() {
		return endReportDate;
	}

	public void setEndReportDate(Date endReportDate) {
		this.endReportDate = endReportDate;
	}

	public Date getStartCheckDate() {
		return startCheckDate;
	}

	public void setStartCheckDate(Date startCheckDate) {
		this.startCheckDate = startCheckDate;
	}

	public Date getEndCheckDate() {
		return endCheckDate;
	}

	public void setEndCheckDate(Date endCheckDate) {
		this.endCheckDate = endCheckDate;
	}

	public Long getCheckType() {
		return checkType;
	}

	public void setCheckType(Long checkType) {
		this.checkType = checkType;
	}

	public Long getThirdPartyId() {
		return thirdPartyId;
	}

	public void setThirdPartyId(Long thirdPartyId) {
		this.thirdPartyId = thirdPartyId;
	}

	public HcCheckPlan getHcCheckPlan() {
		return hcCheckPlan;
	}

	public void setHcCheckPlan(HcCheckPlan hcCheckPlan) {
		this.hcCheckPlan = hcCheckPlan;
	}

	public String getCheckDate() {
		return checkDate;
	}

	public void setCheckDate(String checkDate) {
		this.checkDate = checkDate;
	}

	public Long[] getReportFileIdArr() {
		return reportFileIdArr;
	}

	public void setReportFileIdArr(Long[] reportFileIdArr) {
		if(reportFileIdArr!=null){
			List<Long>  list=Arrays.asList(reportFileIdArr);
			 String str="";
		     for(int i=0;i<list.size();i++){
		    	 if(list.get(i)!=null){
		    		 str+=list.get(i)+",";
		    	 }
		     }
			this.reportFileIds = str;
		}
		this.reportFileIdArr = reportFileIdArr;
	}

	public String getCheckTypeName() {
		return checkTypeName;
	}

	public void setCheckTypeName(String checkTypeName) {
		this.checkTypeName = checkTypeName;
	}

	public String getCheckOrgName() {
		return checkOrgName;
	}

	public void setCheckOrgName(String checkOrgName) {
		this.checkOrgName = checkOrgName;
	}

	public String getUpdator() {
		return updator;
	}

	public void setUpdator(String updator) {
		this.updator = updator;
	}

	public List<HcCheckAttachment> getAttachments() {
		return attachments;
	}

	public void setAttachments(List<HcCheckAttachment> attachments) {
		this.attachments = attachments;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}
}