package cn.smarthse.modules.health.entity.work.hccheckplan;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "hc_check_result_collect_data")
public class HcCheckResultCollectData implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病危害因素检测id
     */
    @Column(name = "hc_id")
    private Long hcId;

    /**
     * 行号标识
     */
    @Column(name = "row_flag")
    private String rowFlag;

    /**
     * key名字
     */
    @Column(name = "data_key")
    private String dataKey;

    /**
     * key名字对应的值
     */
    @Column(name = "data_value")
    private String dataValue;

    /**
     * hc_check_result_collect表的id
     */
    @Column(name = "result_collect_id")
    private Long resultCollectId;

    /**
     * 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    @Column(name = "is_selected")
    private Boolean isSelected;

    /**
     * 结果汇总类别（1到17见具体的枚举类）
     */
    @Column(name = "collect_type")
    private Byte collectType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病危害因素检测id
     *
     * @return hc_id - 职业病危害因素检测id
     */
    public Long getHcId() {
        return hcId;
    }

    /**
     * 设置职业病危害因素检测id
     *
     * @param hcId 职业病危害因素检测id
     */
    public void setHcId(Long hcId) {
        this.hcId = hcId;
    }

    /**
     * 获取行号标识
     *
     * @return row_flag - 行号标识
     */
    public String getRowFlag() {
        return rowFlag;
    }

    /**
     * 设置行号标识
     *
     * @param rowFlag 行号标识
     */
    public void setRowFlag(String rowFlag) {
        this.rowFlag = rowFlag == null ? null : rowFlag.trim();
    }

    /**
     * 获取key名字
     *
     * @return data_key - key名字
     */
    public String getDataKey() {
        return dataKey;
    }

    /**
     * 设置key名字
     *
     * @param dataKey key名字
     */
    public void setDataKey(String dataKey) {
        this.dataKey = dataKey == null ? null : dataKey.trim();
    }

    /**
     * 获取key名字对应的值
     *
     * @return data_value - key名字对应的值
     */
    public String getDataValue() {
        return dataValue;
    }

    /**
     * 设置key名字对应的值
     *
     * @param dataValue key名字对应的值
     */
    public void setDataValue(String dataValue) {
        this.dataValue = dataValue == null ? null : dataValue.trim();
    }

    /**
     * 获取hc_check_result_collect表的id
     *
     * @return result_collect_id - hc_check_result_collect表的id
     */
    public Long getResultCollectId() {
        return resultCollectId;
    }

    /**
     * 设置hc_check_result_collect表的id
     *
     * @param resultCollectId hc_check_result_collect表的id
     */
    public void setResultCollectId(Long resultCollectId) {
        this.resultCollectId = resultCollectId;
    }

    /**
     * 获取界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @return is_selected - 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public Boolean getIsSelected() {
        return isSelected;
    }

    /**
     * 设置界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     *
     * @param isSelected 界面上结果类型是否被选中（0，未被选中，1：选中）(暂不使用)
     */
    public void setIsSelected(Boolean isSelected) {
        this.isSelected = isSelected;
    }

    /**
     * 获取结果汇总类别（1到17见具体的枚举类）
     *
     * @return collect_type - 结果汇总类别（1到17见具体的枚举类）
     */
    public Byte getCollectType() {
        return collectType;
    }

    /**
     * 设置结果汇总类别（1到17见具体的枚举类）
     *
     * @param collectType 结果汇总类别（1到17见具体的枚举类）
     */
    public void setCollectType(Byte collectType) {
        this.collectType = collectType;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}