package cn.smarthse.modules.health.entity.work.hccheckplan;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

@Table(name = "hc_check_plan")
public class HcCheckPlan implements Serializable {
	
	/**
	 * 是否整改
	 */
	@Transient
	private Boolean  rectifyStatus;
	
	
	/**
	 * 告知年份
	 */
	@Transient
	private Integer  informYear;
	
	/**
	 * 检测年份
	 */
	@Transient
	private Long checkYear;
	
	/*2.8版本*/
	/**
	 * 检测报告名称 格式改为附件上传
	 */
	@Transient
	private Long[]  checkReportNameFileIdArr;
     
	
	/**
	 * 检测评价报告名称要素名称改为检测报告、检测评价报告，格式改为附件上传，评价（检测）委托书/合同格式改为附件上传
	 */
	@Transient
	private Long[]  checkEvaluateReportNameFileIdArr;
	
	/**
	 *  评价（检测）委托书/合同格式改为附件上传
	 */
	@Transient
	private Long[] evaluateOrCheckFileFileIdArr;
	
	
	
	/*2.7版本*/
	/**
	 * 相关评价工作名称
	 */
	@Transient
	private String relatedJobEvaluationName;
	
	/**
	 * 告知凭证名称
	 */
	@Transient
	private String checkResultCertificateFileNames;
	
	/**
	 * 相关工作评价表Id
	 */
	@Column(name = "related_job_evaluation_id")	
	private Long relatedJobEvaluationId;
	
	/**
	 * 是否已待评价结果上报了，0 未上报 1已上报
	 */
	@Column(name = "is_result_report")	
	private Boolean  isResultReport;
	
	
	/**
	 * 显示异常查看按钮
	 */
	@Transient
	private  String  showViewButt; 
	/**
	 * 用于存储复测的整改项
	 */
	@Column(name = "reform_item_ids")
	private  String  reformItemIds; 
	
	/**
	 * 
	 *  业务类型 13  7  6
	 */
	@Column(name = "from_business_type")
	private Long fromBusinessType;
	
	/**
	 * 三同时，整改，事故Id
	 */
	@Column(name = "from_business_id")
	private Long fromBusinessId;
	
	/**
	 * 关联的检测编号多个以逗号隔开
	 */
	@Transient
	private String checkPNos;
	
	/**
     * 检测点数
     */
	@Transient
    private Integer checkPointCount;
    
    /**
     * 合格检测点数
     */
    @Transient
    private Integer  goodCheckPointCount;
    
    /**
     * 不合格检测点数
     */
    @Transient
    private Integer  noGoodCheckPointCount;
    
    /**
     * 检测合格率
     */
    @Transient
    private String rate;
	
	
	/**
	 * 关联检测Id，多个以逗号隔开 check_plan_type=3（复测）有用
	 */
	@Column(name = "check_pids")
	private String checkPids;
	
	/**
	 * 是否已告知
	 */
	@Transient
	private Boolean isInformed;
	
	/**
	 * 负责人
	 */
	@Transient
	private String managerName;
	
	@Transient
	private String checkTime;
	
	
	@Transient
	private String checkOrgName;
	
	/**
	 * 搜索条件
	 */
	@Transient
	private String searchKey;
	
	/**
	 * 结束时间（用于搜索）
	 */
	@Transient
	private Date endTime;
	
	/**
	 * 开始时间（用于搜索）
	 */
	@Transient
	private Date startTime;
	
	/**
	 * 检测类型名称
	 */
	@Transient
	private String checkTypeName;
	
	/**
	 * 检测结果公布凭证(数组)
	 */
	@Transient
	private Long[] checkResultCertificateFileIdsArr;
	
	/**
	 * 检测点分布示意图(数组)
	 */
	@Transient
	private Long[] checkPointMapFileIdsArr;
	
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select right(uuid_short(),19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 工作编号
     */
    @Column(name = "check_work_no")
    private String checkWorkNo;

    /**
     * 工作名称
     */
    @Column(name = "check_work_name")
    private String checkWorkName;

    /**
     * 检测时间开始
     */
    @Column(name = "check_time_begin")
    private Date checkTimeBegin;

    /**
     * 检测时间结束
     */
    @Column(name = "check_time_end")
    private Date checkTimeEnd;

    /**
     * 检测类型(检测类型表id）
     */
    @Column(name = "check_type")
    private Long checkType;

    /**
     * 负责人
     */
    private Long manager;

    /**
     * 检测服务类型 0 委外检测 1 自行检测
     */
    @Column(name = "check_service_type")
    private Byte checkServiceType;

    /**
     * （服务机构名称）第三方id（委外检测时）或部门id（自行检测时）
     */
    @Column(name = "third_party_or_check_org_id")
    private Long thirdPartyOrCheckOrgId;
    
    /**
     * 报告出具时间
     */
    @Column(name = "give_report_time")
    private Date giveReportTime;

    /**
     * 检测报告名称
     */
    @Column(name = "check_report_name")
    private String checkReportName;

    /**
     * 原件存放位置（检测报告）
     */
    @Column(name = "check_report_location")
    private String checkReportLocation;

    /**
     * 检测评价报告名称
     */
    @Column(name = "check_evaluate_report_name")
    private String checkEvaluateReportName;

    /**
     * 原件存放位置（检测评价报告）
     */
    @Column(name = "check_evaluate_report_location")
    private String checkEvaluateReportLocation;

    /**
     * 评价（检测）委托书/合同
     */
    @Column(name = "evaluate_or_check_file")
    private String evaluateOrCheckFile;

    /**
     * 原件存放位置（评价（检测）委托书/合同）
     */
    @Column(name = "evaluate_or_check_location")
    private String evaluateOrCheckLocation;

    /**
     * 检测点分布示意图(用英文逗号隔开)
     */
    @Column(name = "check_point_map_file_ids")
    private String checkPointMapFileIds;

    /**
     * 检测结果公布凭证(用英文逗号隔开)
     */
    @Column(name = "check_result_certificate_file_ids")
    private String checkResultCertificateFileIds;

    /**
     * 0是可编辑状态，1不可编辑状态 -1：终止 2：完成 3:作废
     */
    private Byte status;

    /**
     * 相关联的检测父检测id
     */
    @Column(name = "check_pid")
    private Long checkPid;

    /**
     * 0-正常,3-复采(整改后检测)
     */
    @Column(name = "check_plan_type")
    private Byte checkPlanType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取工作编号
     *
     * @return check_work_no - 工作编号
     */
    public String getCheckWorkNo() {
        return checkWorkNo;
    }

    /**
     * 设置工作编号
     *
     * @param checkWorkNo 工作编号
     */
    public void setCheckWorkNo(String checkWorkNo) {
        this.checkWorkNo = checkWorkNo == null ? null : checkWorkNo.trim();
    }

    /**
     * 获取工作名称
     *
     * @return check_work_name - 工作名称
     */
    public String getCheckWorkName() {
        return checkWorkName;
    }

    /**
     * 设置工作名称
     *
     * @param checkWorkName 工作名称
     */
    public void setCheckWorkName(String checkWorkName) {
        this.checkWorkName = checkWorkName == null ? null : checkWorkName.trim();
    }

    /**
     * 获取检测时间开始
     *
     * @return check_time_begin - 检测时间开始
     */
    public Date getCheckTimeBegin() {
        return checkTimeBegin;
    }

    /**
     * 设置检测时间开始
     *
     * @param checkTimeBegin 检测时间开始
     */
    public void setCheckTimeBegin(Date checkTimeBegin) {
        this.checkTimeBegin = checkTimeBegin;
    }

    /**
     * 获取检测时间结束
     *
     * @return check_time_end - 检测时间结束
     */
    public Date getCheckTimeEnd() {
        return checkTimeEnd;
    }

    /**
     * 设置检测时间结束
     *
     * @param checkTimeEnd 检测时间结束
     */
    public void setCheckTimeEnd(Date checkTimeEnd) {
        this.checkTimeEnd = checkTimeEnd;
    }

    /**
     * 获取检测类型(检测类型表id）
     *
     * @return check_type - 检测类型(检测类型表id）
     */
    public Long getCheckType() {
        return checkType;
    }

    /**
     * 设置检测类型(检测类型表id）
     *
     * @param checkType 检测类型(检测类型表id）
     */
    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }

    /**
     * 获取负责人
     *
     * @return manager - 负责人
     */
    public Long getManager() {
        return manager;
    }

    /**
     * 设置负责人
     *
     * @param manager 负责人
     */
    public void setManager(Long manager) {
        this.manager = manager;
    }

    /**
     * 获取检测服务类型 0 委外检测 1 自行检测
     *
     * @return check_service_type - 检测服务类型 0 委外检测 1 自行检测
     */
    public Byte getCheckServiceType() {
        return checkServiceType;
    }

    /**
     * 设置检测服务类型 0 委外检测 1 自行检测
     *
     * @param checkServiceType 检测服务类型 0 委外检测 1 自行检测
     */
    public void setCheckServiceType(Byte checkServiceType) {
        this.checkServiceType = checkServiceType;
    }

    /**
     * 获取（服务机构名称）第三方id（委外检测时）或部门id（自行检测时）
     *
     * @return third_party_or_check_org_id - （服务机构名称）第三方id（委外检测时）或部门id（自行检测时）
     */
    public Long getThirdPartyOrCheckOrgId() {
        return thirdPartyOrCheckOrgId;
    }

    /**
     * 设置（服务机构名称）第三方id（委外检测时）或部门id（自行检测时）
     *
     * @param thirdPartyOrCheckOrgId （服务机构名称）第三方id（委外检测时）或部门id（自行检测时）
     */
    public void setThirdPartyOrCheckOrgId(Long thirdPartyOrCheckOrgId) {
        this.thirdPartyOrCheckOrgId = thirdPartyOrCheckOrgId;
    }

    /**
     * 获取检测报告名称
     *
     * @return check_report_name - 检测报告名称
     */
    public String getCheckReportName() {
        return checkReportName;
    }

    /**
     * 设置检测报告名称
     *
     * @param checkReportName 检测报告名称
     */
    public void setCheckReportName(String checkReportName) {
        this.checkReportName = checkReportName == null ? null : checkReportName.trim();
    }

    /**
     * 获取原件存放位置（检测报告）
     *
     * @return check_report_location - 原件存放位置（检测报告）
     */
    public String getCheckReportLocation() {
        return checkReportLocation;
    }

    /**
     * 设置原件存放位置（检测报告）
     *
     * @param checkReportLocation 原件存放位置（检测报告）
     */
    public void setCheckReportLocation(String checkReportLocation) {
        this.checkReportLocation = checkReportLocation == null ? null : checkReportLocation.trim();
    }

    /**
     * 获取检测评价报告名称
     *
     * @return check_evaluate_report_name - 检测评价报告名称
     */
    public String getCheckEvaluateReportName() {
        return checkEvaluateReportName;
    }

    /**
     * 设置检测评价报告名称
     *
     * @param checkEvaluateReportName 检测评价报告名称
     */
    public void setCheckEvaluateReportName(String checkEvaluateReportName) {
        this.checkEvaluateReportName = checkEvaluateReportName == null ? null : checkEvaluateReportName.trim();
    }

    /**
     * 获取原件存放位置（检测评价报告）
     *
     * @return check_evaluate_report_location - 原件存放位置（检测评价报告）
     */
    public String getCheckEvaluateReportLocation() {
        return checkEvaluateReportLocation;
    }

    /**
     * 设置原件存放位置（检测评价报告）
     *
     * @param checkEvaluateReportLocation 原件存放位置（检测评价报告）
     */
    public void setCheckEvaluateReportLocation(String checkEvaluateReportLocation) {
        this.checkEvaluateReportLocation = checkEvaluateReportLocation == null ? null : checkEvaluateReportLocation.trim();
    }

    /**
     * 获取评价（检测）委托书/合同
     *
     * @return evaluate_or_check_file - 评价（检测）委托书/合同
     */
    public String getEvaluateOrCheckFile() {
        return evaluateOrCheckFile;
    }

    /**
     * 设置评价（检测）委托书/合同
     *
     * @param evaluateOrCheckFile 评价（检测）委托书/合同
     */
    public void setEvaluateOrCheckFile(String evaluateOrCheckFile) {
        this.evaluateOrCheckFile = evaluateOrCheckFile == null ? null : evaluateOrCheckFile.trim();
    }

    /**
     * 获取原件存放位置（评价（检测）委托书/合同）
     *
     * @return evaluate_or_check_location - 原件存放位置（评价（检测）委托书/合同）
     */
    public String getEvaluateOrCheckLocation() {
        return evaluateOrCheckLocation;
    }

    /**
     * 设置原件存放位置（评价（检测）委托书/合同）
     *
     * @param evaluateOrCheckLocation 原件存放位置（评价（检测）委托书/合同）
     */
    public void setEvaluateOrCheckLocation(String evaluateOrCheckLocation) {
        this.evaluateOrCheckLocation = evaluateOrCheckLocation == null ? null : evaluateOrCheckLocation.trim();
    }

    /**
     * 获取检测点分布示意图(用英文逗号隔开)
     *
     * @return check_point_map_file_ids - 检测点分布示意图(用英文逗号隔开)
     */
    public String getCheckPointMapFileIds() {
        return checkPointMapFileIds;
    }

    /**
     * 设置检测点分布示意图(用英文逗号隔开)
     *
     * @param checkPointMapFileIds 检测点分布示意图(用英文逗号隔开)
     */
    public void setCheckPointMapFileIds(String checkPointMapFileIds) {
        this.checkPointMapFileIds = checkPointMapFileIds == null ? null : checkPointMapFileIds.trim();
    }

    /**
     * 获取检测结果公布凭证(用英文逗号隔开)
     *
     * @return check_result_certificate_file_ids - 检测结果公布凭证(用英文逗号隔开)
     */
    public String getCheckResultCertificateFileIds() {
        return checkResultCertificateFileIds;
    }

    /**
     * 设置检测结果公布凭证(用英文逗号隔开)
     *
     * @param checkResultCertificateFileIds 检测结果公布凭证(用英文逗号隔开)
     */
    public void setCheckResultCertificateFileIds(String checkResultCertificateFileIds) {
        this.checkResultCertificateFileIds = checkResultCertificateFileIds == null ? null : checkResultCertificateFileIds.trim();
    }

    /**
     * 获取0是可编辑状态，1不可编辑状态 -1：终止 2：完成
     *
     * @return status - 0是可编辑状态(可编辑就是正在进行的)，1不可编辑状态 -1：终止 2：完成
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置0是可编辑状态，1不可编辑状态 -1：终止 2：完成
     *
     * @param status 0是可编辑状态，1不可编辑状态 -1：终止 2：完成
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取相关联的检测父检测id
     *
     * @return check_pid - 相关联的检测父检测id
     */
    public Long getCheckPid() {
        return checkPid;
    }

    /**
     * 设置相关联的检测父检测id
     *
     * @param checkPid 相关联的检测父检测id
     */
    public void setCheckPid(Long checkPid) {
        this.checkPid = checkPid;
    }

    /**
     * 获取0-正常,3-复采(整改后检测)
     *
     * @return check_plan_type - 0-正常,3-复采(整改后检测)
     */
    public Byte getCheckPlanType() {
        return checkPlanType;
    }

    /**
     * 设置0-正常,3-复采(整改后检测)
     *
     * @param checkPlanType 0-正常,3-复采(整改后检测)
     */
    public void setCheckPlanType(Byte checkPlanType) {
        this.checkPlanType = checkPlanType;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public Long[] getCheckPointMapFileIdsArr() {
		return checkPointMapFileIdsArr;
	}

	public void setCheckPointMapFileIdsArr(Long[] checkPointMapFileIdsArr) {
		this.checkPointMapFileIdsArr = checkPointMapFileIdsArr;
		if(checkPointMapFileIdsArr!=null){
			List<Long>  list=Arrays.asList(checkPointMapFileIdsArr);
			 String str="";
		     for(int i=0;i<list.size();i++){
		    	 if(list.get(i)!=null){
		    		 str+=list.get(i)+",";
		    	 }
		     }
			
			this.checkPointMapFileIds = str;
		}
	}

	public Long[] getCheckResultCertificateFileIdsArr() {
		return checkResultCertificateFileIdsArr;
	}

	public void setCheckResultCertificateFileIdsArr(Long[] checkResultCertificateFileIdsArr) {
		this.checkResultCertificateFileIdsArr = checkResultCertificateFileIdsArr;
		if(checkResultCertificateFileIdsArr!=null){
			List<Long>  list=Arrays.asList(checkResultCertificateFileIdsArr);
			 String str="";
		     for(int i=0;i<list.size();i++){
		    	 if(list.get(i)!=null){
		    		 str+=list.get(i)+",";
		    	 }
		     }
			this.checkResultCertificateFileIds = str;
		}
	}

	public String getCheckTypeName() {
		return checkTypeName;
	}

	public void setCheckTypeName(String checkTypeName) {
		this.checkTypeName = checkTypeName;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getSearchKey() {
		return searchKey;
	}

	public void setSearchKey(String searchKey) {
		this.searchKey = searchKey;
	}

	public String getCheckOrgName() {
		return checkOrgName;
	}

	public void setCheckOrgName(String checkOrgName) {
		this.checkOrgName = checkOrgName;
	}

	public String getCheckTime() {
		return checkTime;
	}

	public void setCheckTime(String checkTime) {
		this.checkTime = checkTime;
	}

	public String getManagerName() {
		return managerName;
	}

	public void setManagerName(String managerName) {
		this.managerName = managerName;
	}

	public Boolean getIsInformed() {
		return isInformed;
	}

	public void setIsInformed(Boolean isInformed) {
		this.isInformed = isInformed;
	}

	public String getCheckPids() {
		return checkPids;
	}

	public void setCheckPids(String checkPids) {
		this.checkPids = checkPids;
	}

	public Integer getCheckPointCount() {
		return checkPointCount;
	}

	public void setCheckPointCount(Integer checkPointCount) {
		this.checkPointCount = checkPointCount;
	}

	public Integer getGoodCheckPointCount() {
		return goodCheckPointCount;
	}

	public void setGoodCheckPointCount(Integer goodCheckPointCount) {
		this.goodCheckPointCount = goodCheckPointCount;
	}

	public String getRate() {
		return rate;
	}

	public void setRate(String rate) {
		this.rate = rate;
	}

	public String getCheckPNos() {
		return checkPNos;
	}

	public void setCheckPNos(String checkPNos) {
		this.checkPNos = checkPNos;
	}

	public Long getFromBusinessType() {
		return fromBusinessType;
	}

	public void setFromBusinessType(Long fromBusinessType) {
		this.fromBusinessType = fromBusinessType;
	}

	public Long getFromBusinessId() {
		return fromBusinessId;
	}

	public void setFromBusinessId(Long fromBusinessId) {
		this.fromBusinessId = fromBusinessId;
	}

	public String getReformItemIds() {
		return reformItemIds;
	}

	public void setReformItemIds(String reformItemIds) {
		this.reformItemIds = reformItemIds;
	}

	public String getShowViewButt() {
		return showViewButt;
	}

	public void setShowViewButt(String showViewButt) {
		this.showViewButt = showViewButt;
	}

	public Boolean getIsResultReport() {
		return isResultReport;
	}

	public void setIsResultReport(Boolean isResultReport) {
		this.isResultReport = isResultReport;
	}

	public Integer getNoGoodCheckPointCount() {
		return noGoodCheckPointCount;
	}

	public void setNoGoodCheckPointCount(Integer noGoodCheckPointCount) {
		this.noGoodCheckPointCount = noGoodCheckPointCount;
	}

	public Long getRelatedJobEvaluationId() {
		return relatedJobEvaluationId;
	}

	public void setRelatedJobEvaluationId(Long relatedJobEvaluationId) {
		this.relatedJobEvaluationId = relatedJobEvaluationId;
	}

	public String getCheckResultCertificateFileNames() {
		return checkResultCertificateFileNames;
	}

	public void setCheckResultCertificateFileNames(String checkResultCertificateFileNames) {
		this.checkResultCertificateFileNames = checkResultCertificateFileNames;
	}

	public String getRelatedJobEvaluationName() {
		return relatedJobEvaluationName;
	}

	public void setRelatedJobEvaluationName(String relatedJobEvaluationName) {
		this.relatedJobEvaluationName = relatedJobEvaluationName;
	}

	public Long[] getCheckReportNameFileIdArr() {
		return checkReportNameFileIdArr;
	}


	public Long[] getCheckEvaluateReportNameFileIdArr() {
		return checkEvaluateReportNameFileIdArr;
	}

	public void setCheckEvaluateReportNameFileIdArr(Long[] checkEvaluateReportNameFileIdArr) {
		this.checkEvaluateReportNameFileIdArr = checkEvaluateReportNameFileIdArr;
		if(checkEvaluateReportNameFileIdArr!=null){
			List<Long>  list=Arrays.asList(checkEvaluateReportNameFileIdArr);
			 String str="";
		     for(int i=0;i<list.size();i++){
		    	 if(list.get(i)!=null){
		    		 str+=list.get(i)+",";
		    	 }
		     }
			this.checkEvaluateReportName = str;
		}
	}

	public Long[] getEvaluateOrCheckFileFileIdArr() {
		return evaluateOrCheckFileFileIdArr;
	}

	public void setEvaluateOrCheckFileFileIdArr(Long[] evaluateOrCheckFileFileIdArr) {
		this.evaluateOrCheckFileFileIdArr = evaluateOrCheckFileFileIdArr;
		if(evaluateOrCheckFileFileIdArr!=null){
			List<Long>  list=Arrays.asList(evaluateOrCheckFileFileIdArr);
			 String str="";
		     for(int i=0;i<list.size();i++){
		    	 if(list.get(i)!=null){
		    		 str+=list.get(i)+",";
		    	 }
		     }
			this.evaluateOrCheckFile = str;
		}
	}
	
   /*服务机构端*/
    @Transient
    private String projAppearName;
    
    @Transient
    private Integer overproofCount;
    @Transient
  	private String thirdOrgName;
    
    /**
     * 上报时间
     */
    @Transient
    private String reportTime;
    
    @Transient
    private String companyName;
    
    /**
     * 检测类型名称
     */
    @Transient
    private String hcCheckTypeName;
    @Transient
    private String projAreaName;
    
    
    /**
     * 上报时间
     */
    @Column(name = "org_report_time")
    private Date orgReportTime;
    


    /**
     * 项目区域id
     */
    @Column(name = "proj_area_id")
    private Long projAreaId;
    /**
     * 项目区域详细信息
     */
    @Column(name = "proj_area_detail")
    private String projAreaDetail;
    /**
     * 联系人
     */
    @Column(name = "link_man")
    private String linkMan;
    
    /**
     * 联系电话
     */
    @Column(name = "link_tel")
    private String linkTel;
    
    /**
     * 1来自企业端检测（全国） 2来自服务机构端检测上报 3来自服务机构端评价里面的检测上报 4来自企业端新增（浙江部分）
     */
    @Column(name = "check_data_source")
    private Byte checkDataSource;
    
    
    
    /**
     *评价id
     */
    @Column(name = "evaluate_id")
    private Long evaluateId;
    
    /**
     *上报状态 1 草稿 2 已上报
     */
    @Column(name = "proj_appear_status")
    private Byte projAppearStatus;
    
	
    /**
     * 登记人
     */
    private String registrant;
    
    @Column(name = "org_id")
    private Long orgId;
    
    
    
	public Byte getCheckDataSource() {
		return checkDataSource;
	}
	public void setCheckDataSource(Byte checkDataSource) {
		this.checkDataSource = checkDataSource;
	}

	
    
    public Long getProjAreaId() {
		return projAreaId;
	}
	public void setProjAreaId(Long projAreaId) {
		this.projAreaId = projAreaId;
	}
	public String getProjAreaDetail() {
		return projAreaDetail;
	}
	public void setProjAreaDetail(String projAreaDetail) {
		this.projAreaDetail = projAreaDetail;
	}
	public String getLinkMan() {
		return linkMan;
	}
	public void setLinkMan(String linkMan) {
		this.linkMan = linkMan;
	}
	public String getLinkTel() {
		return linkTel;
	}
	public void setLinkTel(String linkTel) {
		this.linkTel = linkTel;
	}
	public Long getEvaluateId() {
		return evaluateId;
	}
	public void setEvaluateId(Long evaluateId) {
		this.evaluateId = evaluateId;
	}
	public Byte getProjAppearStatus() {
		return projAppearStatus;
	}
	public void setProjAppearStatus(Byte projAppearStatus) {
		this.projAppearStatus = projAppearStatus;
	}


	
	public String getCompanyName() {
		return companyName;
	}
	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}
	public String getHcCheckTypeName() {
		return hcCheckTypeName;
	}
	public void setHcCheckTypeName(String hcCheckTypeName) {
		this.hcCheckTypeName = hcCheckTypeName;
	}
	public Date getOrgReportTime() {
		return orgReportTime;
	}
	public void setOrgReportTime(Date orgReportTime) {
		this.orgReportTime = orgReportTime;
	}
	public String getProjAreaName() {
		return projAreaName;
	}
	public void setProjAreaName(String projAreaName) {
		this.projAreaName = projAreaName;
	}
	public String getReportTime() {
		return reportTime;
	}
	public void setReportTime(String reportTime) {
		this.reportTime = reportTime;
	}
	public String getProjAppearName() {
		if(projAppearStatus!=null) {
		if(projAppearStatus==1) {
			projAppearName="存草稿";
		}else if(projAppearStatus==2) {
			projAppearName="已上报";
		}else {
			projAppearName="";
		}
		}
		return projAppearName;
	}
	public void setProjAppearName(String projAppearName) {
		this.projAppearName = projAppearName;
	}
	public void setCheckReportNameFileIdArr(Long[] checkReportNameFileIdArr) {
		this.checkReportNameFileIdArr = checkReportNameFileIdArr;
		if(checkReportNameFileIdArr!=null){
			List<Long>  list=Arrays.asList(checkReportNameFileIdArr);
			 String str="";
		     for(int i=0;i<list.size();i++){
		    	 if(list.get(i)!=null){
		    		 str+=list.get(i)+",";
		    	 }
		     }
			this.checkReportName = str;
		}
	}

	public Integer getOverproofCount() {
		return overproofCount;
	}

	public void setOverproofCount(Integer overproofCount) {
		this.overproofCount = overproofCount;
	}

	public String getThirdOrgName() {
		return thirdOrgName;
	}

	public void setThirdOrgName(String thirdOrgName) {
		this.thirdOrgName = thirdOrgName;
	}

	public String getRegistrant() {
		return registrant;
	}

	public void setRegistrant(String registrant) {
		this.registrant = registrant;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Date getGiveReportTime() {
		return giveReportTime;
	}

	public void setGiveReportTime(Date giveReportTime) {
		this.giveReportTime = giveReportTime;
	}

	public Long getCheckYear() {
		return checkYear;
	}

	public void setCheckYear(Long checkYear) {
		this.checkYear = checkYear;
	}

	public Boolean getRectifyStatus() {
		return rectifyStatus;
	}

	public void setRectifyStatus(Boolean rectifyStatus) {
		this.rectifyStatus = rectifyStatus;
	}

	public Integer getInformYear() {
		return informYear;
	}

	public void setInformYear(Integer informYear) {
		this.informYear = informYear;
	}
	
}