package cn.smarthse.modules.health.entity.work.hccheckplan;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "hc_check_onizing_radiation_result")
public class HcCheckOnizingRadiationResult implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 检测id
     */
    @Column(name = "hc_id")
    private Long hcId;

    /**
     * 检测点位置
     */
    @Column(name = "check_point_location")
    private String checkPointLocation;

    /**
     * 检测结果1
     */
    @Column(name = "check_result1")
    private String checkResult1;

    /**
     * 检测结果2
     */
    @Column(name = "check_result2")
    private String checkResult2;

    /**
     * 行号标识
     */
    @Column(name = "row_flag")
    private String rowFlag;

    /**
     * 判断结果加电离辐射判定结果
     */
    private String result;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取检测id
     *
     * @return hc_id - 检测id
     */
    public Long getHcId() {
        return hcId;
    }

    /**
     * 设置检测id
     *
     * @param hcId 检测id
     */
    public void setHcId(Long hcId) {
        this.hcId = hcId;
    }

    /**
     * 获取检测点位置
     *
     * @return check_point_location - 检测点位置
     */
    public String getCheckPointLocation() {
        return checkPointLocation;
    }

    /**
     * 设置检测点位置
     *
     * @param checkPointLocation 检测点位置
     */
    public void setCheckPointLocation(String checkPointLocation) {
        this.checkPointLocation = checkPointLocation == null ? null : checkPointLocation.trim();
    }

    /**
     * 获取检测结果1
     *
     * @return check_result1 - 检测结果1
     */
    public String getCheckResult1() {
        return checkResult1;
    }

    /**
     * 设置检测结果1
     *
     * @param checkResult1 检测结果1
     */
    public void setCheckResult1(String checkResult1) {
        this.checkResult1 = checkResult1 == null ? null : checkResult1.trim();
    }

    /**
     * 获取检测结果2
     *
     * @return check_result2 - 检测结果2
     */
    public String getCheckResult2() {
        return checkResult2;
    }

    /**
     * 设置检测结果2
     *
     * @param checkResult2 检测结果2
     */
    public void setCheckResult2(String checkResult2) {
        this.checkResult2 = checkResult2 == null ? null : checkResult2.trim();
    }

    /**
     * 获取行号标识
     *
     * @return row_flag - 行号标识
     */
    public String getRowFlag() {
        return rowFlag;
    }

    /**
     * 设置行号标识
     *
     * @param rowFlag 行号标识
     */
    public void setRowFlag(String rowFlag) {
        this.rowFlag = rowFlag == null ? null : rowFlag.trim();
    }

    /**
     * 获取判断结果加电离辐射判定结果
     *
     * @return result - 判断结果加电离辐射判定结果
     */
    public String getResult() {
        return result;
    }

    /**
     * 设置判断结果加电离辐射判定结果
     *
     * @param result 判断结果加电离辐射判定结果
     */
    public void setResult(String result) {
        this.result = result == null ? null : result.trim();
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}