package cn.smarthse.modules.health.entity.work.harmfactor.Vo;

import lombok.Data;
import org.apache.commons.collections4.MapUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public @Data class HarmfactorWorkAreaSourceVo  implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
//	private Long id;
	private String reportName;
	private String harmFactorNames;

	private String harmFactorNamesAndIds;

	private String areaIds;
	private String chooseAreaInfo;
	private Set<Long> areaIdSet=new HashSet<>();
	private String areaNames;
	private Set<String> areaNameSet=new HashSet<>();
	private Set<Map<String, String>> areaIdNameMapSet = new HashSet<>();

	private String checkStartTime;
	
	/*
	 * 是否有关联的历史记录
	 */
	private boolean hasHisRec;

	public void addAreaIdNameMap(String areaId, String areaNames) {
		boolean addFlag = true;
		for (Map<String, String> stringStringMap : areaIdNameMapSet) {
			String id = MapUtils.getString(stringStringMap, "id", "");
			String name = MapUtils.getString(stringStringMap, "name", "");
			if ((id + name).equals(areaId + areaNames)) {
				addFlag = false;
			}
		}
		if (addFlag) {
			Map<String, String> map = new HashMap<>();
			map.put("id", areaId+"");
			map.put("name", areaNames);
			this.areaIdNameMapSet.add(map);
		}
	}
}